#ifndef filtersjared_H_
#define filtersjared_H_

#define DEMODULATION_LENGTH 125
#define MAX_NUMBER_OF_FILTERS 8

#include "dsp.h"
#include "mbed.h"
#include "demodulate.h"
#include "print_data.h"

class filters
{
    public:
        filters();//I have not implemented the standard initialization yet.
        
        //intializes a bank of 8 filters
        filters(const int num_filters, const int DECIMATION, filters * f, const int block_size, const int numTaps, float coeffs[], int demodulate_after);
        //filters a bank of inputs
        void input(float *input_samples[MAX_NUMBER_OF_FILTERS], int length, int print_identifier);
        //demodulates the signal after being filtered and decimated.
        //void demodulate();
    private:
        filters * _next_filter;//points to the next bank of filters.
        int _demodulate_after;//boolean that when it is true demodulates the signal afterwards
        int _block_size;//number of input samples to process at a time
        int _num_filters;//the number of filters to be used.  max is 8, used when there are 4 different channels all with in-phase and quadrature components
        int _decimation_number;//the number of decimated samples
        int _block_size_counter;
        float *_output_samples[MAX_NUMBER_OF_FILTERS];//an array of 8 pointers. each points to an array of floats representing the output.
        float *_filter_input[MAX_NUMBER_OF_FILTERS];//an array of 8 pointers. each points to an array of floats representing the input.
        //static int _demodulation_counter;
        arm_fir_decimate_instance_f32 _filterStruct[MAX_NUMBER_OF_FILTERS];//required to use prebuilt decimation function      
};
#endif