#include "demodulate.h"

#define MAX_NUMBER_DEMOD_FREQ 1  //Number of sinusoids in composite signal

#define DEMOD_EXTRA_TABLE_LENGTH 16 //small extra wrap-around buffer, probably not necassary
#define TWOPI 6.28318530717959

float *imod[MAX_NUMBER_DEMOD_FREQ]; //inphase cos(wt)
float *qmod[MAX_NUMBER_DEMOD_FREQ]; //quadrature phase
float demod_Carrier_Frequency[MAX_NUMBER_DEMOD_FREQ] = {100000/pre_compute_length};
float demod_Table_Length[MAX_NUMBER_DEMOD_FREQ] = {pre_compute_length/8};
float demod_Sample_Frequency[MAX_NUMBER_DEMOD_FREQ] = {100000/8};

void precompute_tables()
{
    static bool precomputed = false;
    if (precomputed)
    {
        printf("TABLES HAVE ALREADY BEEN PRECOMPUTED");
        return;
    }
    precomputed = true;
    for (int i = 0; i<MAX_NUMBER_DEMOD_FREQ; i++)
    {
        int table_size = demod_Table_Length[i]+DEMOD_EXTRA_TABLE_LENGTH;
        imod[i] = new float[table_size];
        qmod[i] = new float[table_size];
        for(int precompute_counter = 0; precompute_counter < demod_Table_Length[i]+DEMOD_EXTRA_TABLE_LENGTH; precompute_counter++)
        {
            imod[i][precompute_counter] = ( cos(TWOPI * demod_Carrier_Frequency[i] / demod_Sample_Frequency[i] * precompute_counter));
            qmod[i][precompute_counter] = (-sin(TWOPI * demod_Carrier_Frequency[i] / demod_Sample_Frequency[i] * precompute_counter));
        }
    }
    
}
void demodulate(float *samples[MAX_NUMBER_OF_FILTERS], int num_filters, int sample_length, int demodulation_frequency)
{
    static int demod_counters[MAX_NUMBER_DEMOD_FREQ] = {0};
    
    if (demod_counters[demodulation_frequency]>=demod_Table_Length[demodulation_frequency])
    {
        demod_counters[demodulation_frequency]-=demod_Table_Length[demodulation_frequency];
    }
    for(int i = num_filters-1; i>=0; i--)
    {
        //important keep in this order or filter 0 will be odd
        //multiply by -sin
        arm_mult_f32(qmod[demodulation_frequency]+demod_counters[demodulation_frequency], samples[i], samples[2*i+1], sample_length);
        //multiply by cos
        arm_mult_f32(imod[demodulation_frequency]+demod_counters[demodulation_frequency], samples[i], samples[2*i], sample_length);
    }
    demod_counters[demodulation_frequency] +=sample_length;//increment counter
}
