#include "print_data.h"

#define NUM_PRINT_INPUTS 2
DigitalOut status_2(D4);
int printing_length[NUM_PRINT_INPUTS] = {0};
int printing_counter[NUM_PRINT_INPUTS] = {0};
char print_buffer[NUM_PRINT_INPUTS][50];




void print_filter_data(Serial *pc, bool is_actively_printing)
{
    static int current_print_frequency = 0;
    if (printing_counter[current_print_frequency]>=printing_length[current_print_frequency])
    {
        printing_counter[current_print_frequency]= 0;
        printing_length[current_print_frequency] = 0;
        current_print_frequency++;
        if (current_print_frequency>=NUM_PRINT_INPUTS)
        {
            current_print_frequency=0;
        }
        return;
    }    
    status_2 = 1;
    //printf("Y");
    if (is_actively_printing)
    {
        pc->printf("%c",print_buffer[current_print_frequency][printing_counter[current_print_frequency]]);
    }
    printing_counter[current_print_frequency]++;

    status_2 = 0;
}
void set_print_buffer(double mag,double phase, int print_identifier)
{
    
    
    if (printing_counter<printing_length)
    {
        printf("PRINT OVERLOAD\n\r");
    }
    
    printing_length[print_identifier]=sprintf (print_buffer[print_identifier], "%d %.3E %.3f %.4f\n\r",print_identifier, mag, phase, timer.read());
    //printing_counter[print_identifier] = 0;
    
}