#include "pdb.h"

//Serial debug2(USBTX,USBRX);

void pdb_init() {
    
    // initialize the Programmable Delay Block
    
    // turn on the clock to the PDB
    SIM->SCGC6 |= SIM_SCGC6_PDB_MASK;
       
    // Configure the Peripheral Delay Block (PDB):
    //PDB0_MOD = 0x0000ffff; // max
    PDB0->MOD = (uint16_t) 600; // 60 MHz divided by this value is the sampling frequency
    //PDB0_MOD = (uint16_t) 3000; // 60 MHz divided by this value is the sampling frequency
    PDB0->CH[0].DLY[0] = 0x00;
    PDB0->CH[0].DLY[1] = 0x00;
    PDB0->CH[1].DLY[0] = 0x00;
    PDB0->CH[1].DLY[1] = 0x00;
    PDB0->CH[0].C1 = PDB_C1_EN(1) | PDB_C1_TOS(1); // channel 0 pretrigger 0 and 1 enabled and delayed
    PDB0->CH[1].C1 = PDB_C1_EN(1) | PDB_C1_TOS(1); // channel 1 pretrigger 0 and 1 enabled and delayed

    // want to use PDB interrupt delay for the DAC
    PDB0->IDLY = 0x01;
    
    
    // Setup Staus and Control Register
    PDB0->SC = 0; // clear register
    PDB0->SC = PDB_SC_DMAEN_MASK    // Enable DMA
             | PDB_SC_PRESCALER(0) // No pre-scale
             | PDB_SC_TRGSEL(0xf)  // Trigger source is Software Trigger to be invoked in this file
             | PDB_SC_PDBEN_MASK   // PDB enabled
             & ~PDB_SC_PDBIE_MASK  // PDB Interrupt Disable
             | PDB_SC_MULT(0)      // Multiplication factor 0
             & ~PDB_SC_CONT_MASK    // One-shot Mode
             | PDB_SC_LDOK_MASK;   // Need to ok the loading or it will not load certain regsiters!
    
    //NVIC_SetVector(PDB0_IRQn, (uint32_t)&PDB0_IRQHandler);
    //NVIC_EnableIRQ(PDB0_IRQn);
}

void PDB0_IRQHandler() {
    /*
    static bool is_magnified_sample = true;
    if (is_magnified_sample)
    {
        ADC0_SC1A = 0x0D;
    }
    else
    {
        ADC0_SC1A = 0x0C;
    }
    is_magnified_sample = !is_magnified_sample;
    */
}

void pdb_start() {
    PDB0->SC |= PDB_SC_PDBEN_MASK;  // PDB enabled
    PDB0->SC |= PDB_SC_CONT_MASK; // Set for continuous acquisition
    PDB0->SC |= PDB_SC_SWTRIG_MASK; // enable software trigger (start the PDB) and resets counter to zero.
}

void pdb_stop() {
    PDB0->SC &= ~PDB_SC_CONT_MASK; // change to one-shot mode, so pdb will stop after current count
    PDB0->SC &= ~PDB_SC_PDBEN_MASK;  // PDB disabled
}

void pdb_step() {
    PDB0->SC |= PDB_SC_PDBEN_MASK;  // PDB enabled
    //PDB0_SC |= PDB_SC_CONT_MASK; // Set for continuous acquisition
    PDB0->SC |= PDB_SC_SWTRIG_MASK; // enable software trigger (start the PDB) and resets counter to zero.
}



/*
    debug2.printf("PDB0_SC:       %08x\r\n",PDB0_SC);
    debug2.printf("PDB0_MOD:      %08x\r\n",PDB0_MOD);
    debug2.printf("PDB0_CNT:      %08x\r\n",PDB0_CNT);
    debug2.printf("PDB0_IDLY:     %08x\r\n",PDB0_IDLY);
    debug2.printf("PDB0_CH0C1:    %08x\r\n",PDB0_CH0C1);
    debug2.printf("PDB0_CH0S:     %08x\r\n",PDB0_CH0S);
    debug2.printf("PDB0_CH0DLY0:  %08x\r\n",PDB0_CH0DLY0);
    debug2.printf("PDB0_CH0DLY1:  %08x\r\n",PDB0_CH0DLY1);
    debug2.printf("PDB0_CH1C1:    %08x\r\n",PDB0_CH1C1);
    debug2.printf("PDB0_CH1S:     %08x\r\n",PDB0_CH1S);
    debug2.printf("PDB0_CH1DLY0:  %08x\r\n",PDB0_CH1DLY0);
    debug2.printf("PDB0_CH1DLY1:  %08x\r\n",PDB0_CH1DLY1);
    debug2.printf("PDB0_DACINTC0: %08x\r\n",PDB0_DACINTC0);
    debug2.printf("PDB0_DACINT0:  %08x\r\n",PDB0_DACINT0);
    debug2.printf("PDB0_DACINTC1: %08x\r\n",PDB0_DACINTC1);
    debug2.printf("PDB0_DACINT1:  %08x\r\n",PDB0_DACINT1);
    debug2.printf("PDB0_POEN:     %08x\r\n",PDB0_POEN);
    debug2.printf("PDB0_PO0DLY:   %08x\r\n",PDB0_PO0DLY);
    debug2.printf("PDB0_PO1DLY:   %08x\r\n",PDB0_PO1DLY);
    debug2.printf("PDB0_PO2DLY:   %08x\r\n\n",PDB0_PO2DLY);
    */