#ifndef I2C_MBED_FPGA_H
#define I2C_MBED_FPGA_H

#include "nv_bitfield_map.h"
#include "i2c_ram_defines.h"
#include "nv_defaults.h"
#include "mbed.h"


#define I2C_SLAVE_ADDR 0x6A<<1

//Class delclarations
class i2c_mbed_fpga {

public:    
    /*constructor*/  
    // {p28:sda, p27:scl}
    // {p9: sda, p10:scl}  
    i2c_mbed_fpga(): i2c_master(p9, p10){  
        i2c_master.frequency(100000);
        nv_positin_val = NV_POSITION_DEFAULT;
        nv_start_up_val = NV_START_UP_DEFAULT; 
        nv_wind_brake_val = NV_WIND_BRAKE_DEFAULT;
        ram_open_duty_val = RAM_OPEN_DUTY_DEFAULT;
        nv_spd_control_1_val = NV_SPD_CONTROL_1_DEFAULT;
        nv_spd_control_2_val = NV_SPD_CONTROL_1_DEFAULT;
        nv_gen_ctrl_val = NV_GEN_CTRL_DEFAULT; 
        nv_application_cfg_val = NV_APPLICATION_CFG_DEFAULT;
        nv_i_zc_th_high_val = NV_I_ZC_TH_HIGH_DEFAULT;
        nv_i_zc_th_low_val = NV_I_ZC_TH_LOW_DEFAULT; 
        nv_di_th_1st_val = NV_DI_TH_1ST_DEFAULT; 
        nv_di_th_2nd_val = NV_DI_TH_2ND_DEFAULT;
        nv_dig_config_val = NV_DIG_CONFIG_DEFAULT;  
        nv_clim_user_0_val = NV_CLIM_USER_0_DEFAULT;
        nv_clim_user_1_val = NV_CLIM_USER_1_DEFAULT; 
        nv_positin2_val = NV_CLIM_POSITIN2_DEFAULT;  
        ram_debug_ctrl_val = RAM_DEBUG_CTRL_DEFAULT;
    };
    
    int i2c_word_read(char *word);
    int i2c_word_read_simple(char address, int* return_value);
    int i2c_word_read_interpreter(int address, int* return_value);
    int i2c_word_write(char *word);
    int i2c_word_write_simple(char address, int value);
    int i2c_word_write_interpreter(int address, int value);

    //int i2c_window_open();
    //int i2c_motor_start();
    
    int i2c_config_mode_entry();
    int i2c_mlx_mode_entry();
    int i2c_skip_app_copy();
    int i2c_soft_reset();
    bool i2c_check_busy_flag(void);
    void wait_for_idle_state(void);
    
    
    int i2c_set_50k_pwm(unsigned int pwm50k);
    
    int i2c_set_position_pulse_width(unsigned int manstisa_2b, unsigned int exponenet_3b);
    int i2c_set_position_flat(unsigned int mantisaa_2b, unsigned int exponent_3b);
    int i2c_set_position_duty(unsigned int duty_2b);
    int i2c_set_position_maj_vote(unsigned int maj_1b);
    int i2c_set_position_anti_cog(unsigned int cog_1b);
    
    int i2c_set_start_up_pulse_width(unsigned int mantisaa_3b, unsigned int exponent_3b);
    
    int i2c_set_start_up_duty(unsigned int duty_2b);
    int i2c_set_start_up_flat(unsigned int mantisaa_3b, unsigned int exponent_3b);
    int i2c_set_start_up_num_comm(unsigned int comm);
    int i2c_set_soft_start_up(unsigned int enbale, unsigned int mantisaa_3b, unsigned int exponent_3b, unsigned int step_size, unsigned int num_steps);
    int i2c_set_high_torque_start_up(unsigned int enbale, unsigned int mantisaa_3b, unsigned int exponent_3b);
    int i2c_set_single_pulse_start_up(unsigned int enbale, unsigned int mantisaa_3b, unsigned int exponent_3b);
    
    int i2c_force_rough_reg(unsigned int reg);
    int i2c_set_rough_gain(unsigned int rough_gain);
    int i2c_set_ehp_reg_gain(unsigned int ehp_gain);
    int i2c_set_fall_time_blank(unsigned int blank_time);
    
    int i2c_set_comm_i_thres(unsigned int i_thr_low, unsigned int i_thr_high);
    int i2c_set_comm_di_thres(unsigned int di_1st, unsigned int di_2nd);
    
    
    int i2c_clear_spd_ctrl();
    int i2c_set_input_mode(unsigned int mode);
    int i2c_set_loop_mode(unsigned int openloop);
    int i2c_set_curve_type(unsigned int curvetype);
    int i2c_set_dc_ini(unsigned int ini);
    int i2c_set_dc_sr(unsigned int sr);
    int i2c_set_open_loop_duty(unsigned int duty);
    
    int i2c_set_clim_start_up(unsigned int clim);
    int i2c_set_clim_brake(unsigned int clim);
    int i2c_set_clim_run_time(unsigned int clim);
    
    int i2c_enable_pules_debug_mode(unsigned int enable);
    
private:
    I2C i2c_master;
    unsigned int nv_positin_val;
    unsigned int nv_start_up_val;
    unsigned int nv_wind_brake_val;
    unsigned int nv_spd_control_1_val;
    unsigned int nv_spd_control_2_val;
    unsigned int ram_open_duty_val;
    unsigned int nv_gen_ctrl_val;
    unsigned int nv_comm_ctrl_val;
    unsigned int nv_application_cfg_val;
    unsigned int nv_i_zc_th_high_val;
    unsigned int nv_i_zc_th_low_val; 
    unsigned int nv_di_th_1st_val; 
    unsigned int nv_di_th_2nd_val;
    unsigned int nv_dig_config_val;
    unsigned int nv_clim_user_1_val; 
    unsigned int nv_clim_user_0_val;
    unsigned int nv_positin2_val;   
    unsigned int ram_debug_ctrl_val;  
    //Position Detection Task/Functions
};



#endif