#ifndef MOTION_H_
#define MOTION_H_
#include <cstdlib>
#include <mbed.h>
#include "EncoderCounter.h"
#include "Controller.h"
#include "Spurhaltung.h"
#include "IRSensorGF.h"
#include "IRSensorG.h"
#include "IRSensorK.h"
#include "IRSensorZ.h"

class Motion {
    

public:
    Motion(EncoderCounter& counterLeft, EncoderCounter& counterRight, Controller& controller, Spurhaltung& spurhaltung, IRSensorGF& Sensor1, IRSensorG& Sensor2, IRSensorG& Sensor3, IRSensorK& Sensor4, IRSensorK& Sensor5, IRSensorZ& Sensor6);
    virtual ~Motion();
    float read();
    int speedr();
    int speedl();
    void gerade();
    void drehenl90();
    void drehenr90();
    void drehen180();
    void switching(int D);
    
private:
    
    EncoderCounter& counterLeft;
    EncoderCounter& counterRight;
    static const float SPEED;
    static const float DREHEN90;
    static const float GERADE;
    Controller& controller;
    Spurhaltung& spurhaltung;
    IRSensorGF& Sensor1;
    IRSensorG& Sensor2;
    IRSensorG& Sensor3;
    IRSensorK& Sensor4;
    IRSensorK& Sensor5;
    IRSensorZ& Sensor6;
    int D;
    



};

#endif /* IR_MOTION_H_ */ 