#include <mbed.h>
#include "EncoderCounter.h"
#include "Controller.h"
#include "IRSensorG.h"
#include "IRSensorGF.h"
#include "IRSensorK.h"
#include "IRSensorZ.h"
#include "Spurhaltung.h"
#include "LHR.h"
#include "Motion.h"

//------------------------------------------------------------------------------

//Motorbefehle von LHR
int D, sl, sr;
Timer timey;

//------------------------------------------------------------------------------

AnalogIn sensorValue1(PC_2);        // Frontsensor mitte
AnalogIn sensorValue2(PC_3);        // Frontsensor links
AnalogIn sensorValue3(PC_5);        // Frontsensor rechts
AnalogIn sensorValue4(PB_1);        // Seitlicher Sensor links
AnalogIn sensorValue5(PA_4);        // Seitlicher Sensor rechts
AnalogIn sensorValue6(PB_0);        // Helligkeitssensor
DigitalOut myled(LED1);             // LED 1
DigitalIn button(USER_BUTTON);    // Startknopf
DigitalOut power_5v(PC_4);          // 5V auf Sensoren, geschalten

DigitalOut enable(PC_1);

DigitalOut enableMotorDriver(PB_2);
DigitalIn motorDriverFault(PB_14);
DigitalIn motorDriverWarning(PB_15);

PwmOut pwmRight(PA_8);
PwmOut pwmLeft(PA_9);

EncoderCounter counterLeft(PB_6, PB_7);
EncoderCounter counterRight(PA_6, PC_7);

//------------------------------------------------------------------------------

Controller controller(pwmLeft, pwmRight, counterLeft, counterRight);

// Grosse Sensoren aufrufen
IRSensorGF Sensor1(sensorValue1);
IRSensorG Sensor2(sensorValue2);
IRSensorG Sensor3(sensorValue3);
// Kleine Sensoren aufrufen
IRSensorK Sensor4(sensorValue4);
IRSensorK Sensor5(sensorValue5);
// Helligkeitssensor aufrufen
IRSensorZ Sensor6(sensorValue6);

//------------------------------------------------------------------------------

int main()
{
    power_5v = 1; // Einschalten 5V Speisung der Sensoren
    enable = 1;
    enableMotorDriver = 1; //Schaltet den Leistungstreiber ein
    LHR LHR(Sensor1, Sensor2, Sensor3, Sensor4, Sensor5, Sensor6);
    Spurhaltung spurhaltung(Sensor2, Sensor3);
    Motion motion(counterLeft, counterRight, controller, spurhaltung, Sensor1, Sensor2, Sensor3, Sensor4, Sensor5, Sensor6);


    if(button==1) {

        while (1) {

            D = LHR.moving();
            //sl = spurhaltung.speedr();
            //printf("Status: %d\r\n", button);
            //sr = spurhaltung.speedl();
            motion.switching(D);
            
            
        }
    }
}