#include "Motion.h"
#include "Controller.h"
#include "EncoderCounter.h"
#include "Spurhaltung.h"
#include "IRSensorGF.h"
#include "IRSensorG.h"
#include "IRSensorK.h"
#include "IRSensorZ.h"

// Left + = Rückwärts Left - = Vorwärts 
// Right + = Vorwärts Right - = Rückwärts

using namespace std;

Motion::Motion(EncoderCounter& counterLeft, EncoderCounter& counterRight, Controller& controller, Spurhaltung& spurhaltung, IRSensorGF& Sensor1, IRSensorG& Sensor2, IRSensorG& Sensor3, IRSensorK& Sensor4, IRSensorK& Sensor5, IRSensorZ& Sensor6):
    counterLeft(counterLeft), counterRight(counterRight), controller(controller), spurhaltung(spurhaltung), Sensor1(Sensor1), Sensor2(Sensor2), Sensor3(Sensor3), Sensor4(Sensor4), Sensor5(Sensor5), Sensor6(Sensor6)
{
    
}

Motion::~Motion() {}

//------------------------------------------------------------------------------

void Motion::drehenl90()
{
    controller.resetCounter();
    int lastCountRight = counterRight.read();

    while(counterRight.read()-lastCountRight>(-1.35*1260)) {
        controller.setDesiredSpeedLeft(150.0f);             //Drehzahl in [rpm]
        controller.setDesiredSpeedRight(150.0f);
        
        
    }

    controller.setDesiredSpeedLeft(0.0f);                   //Drehzahl in [rpm]
    controller.setDesiredSpeedRight(0.0f);
    
    controller.resetCounter();
    int lastCountLeft = counterLeft.read();

    while(counterLeft.read()-lastCountLeft>(-2.094*1260)) {
        controller.setDesiredSpeedLeft(-spurhaltung.speedr());   //Drehzahl in [rpm]
        controller.setDesiredSpeedRight(spurhaltung.speedl());
        spurhaltung.speedl();
        spurhaltung.speedr();

    }

    controller.setDesiredSpeedLeft(0.0f);                       //Drehzahl in [rpm]
    controller.setDesiredSpeedRight(0.0f);
    
}

//------------------------------------------------------------------------------

void Motion::gerade()
{

    controller.resetCounter();
    int lastCountLeft = counterLeft.read();

    while(counterLeft.read()-lastCountLeft>(-2.094*1260)) {
        controller.setDesiredSpeedLeft(-spurhaltung.speedr());   //Drehzahl in [rpm]
        controller.setDesiredSpeedRight(spurhaltung.speedl());
        spurhaltung.speedl();
        spurhaltung.speedr();
    }

    controller.setDesiredSpeedLeft(0.0f);                       //Drehzahl in [rpm]
    controller.setDesiredSpeedRight(0.0f);
}

//------------------------------------------------------------------------------

void Motion::drehenr90()
{
    controller.resetCounter();
    int lastCountLeft = counterLeft.read();

    while(counterLeft.read()-lastCountLeft<(1.35*1260)) {
        controller.setDesiredSpeedLeft(-150.0f);            //Drehzahl in [rpm]
        controller.setDesiredSpeedRight(-150.0f);
        
    }

    controller.setDesiredSpeedLeft(0.0f); //Drehzahl in [rpm]
    controller.setDesiredSpeedRight(0.0f);
    
        controller.resetCounter();
    lastCountLeft = counterLeft.read();

    while(counterLeft.read()-lastCountLeft<(-2.094*1260)) {
        controller.setDesiredSpeedLeft(-spurhaltung.speedr());   //Drehzahl in [rpm]
        controller.setDesiredSpeedRight(spurhaltung.speedl());
        spurhaltung.speedl();
        spurhaltung.speedr();
        
    }

    controller.setDesiredSpeedLeft(0.0f);                       //Drehzahl in [rpm]
    controller.setDesiredSpeedRight(0.0f);
}

//------------------------------------------------------------------------------

void Motion::drehen180()
{
    controller.resetCounter();
    int lastCountRight = counterRight.read();

    while(counterRight.read()-lastCountRight>(-2.7*1260)) {
        controller.setDesiredSpeedLeft(150.0f); //Drehzahl in [rpm]
        controller.setDesiredSpeedRight(150.0f);
        
        
    }

    controller.setDesiredSpeedLeft(0.0f); //Drehzahl in [rpm]
    controller.setDesiredSpeedRight(0.0f);
}

//------------------------------------------------------------------------------

void Motion::switching(int D)
{
    switch(D) {
        case 1:
            // Left
            drehenl90();
            // Forward
            //gerade();
            break;

        case 2:
            // Forward
            gerade();
            break;

        case 3:
            // Right
            drehenr90();
            // Forward
            gerade();
            break;

        case 4:
            // 180 Drehen
            drehen180();
            break;

        default:
            controller.setDesiredSpeedLeft(0.0f); //Drehzahl in [rpm]
            controller.setDesiredSpeedRight(0.0f);
    }
    
//------------------------------------------------------------------------------
    
/*void Motion::switching()
{
     if(Sensor4.read() == 0) {
            // Left
            drehenl90();
            // Forward
            gerade();
    } else if (Sensor1.read() == 0) {
            // Forward
            gerade();
    } else if (Sensor5.read() == 0) {
            // Right
            drehenr90();
            // Forward
            gerade();
    } else {
            // 180 Drehen
            drehen180();
            // Forward
            gerade();

    }*/  

}
