#include "mbed.h"
#include "ds1307.h"
#include "stm32f4xx_hal_iwdg.h"

#if defined(TARGET_NUCLEO_F401RE)
    DS1307 ds1307(PB_9, PB_8);  

    IWDG_HandleTypeDef hiwdg;
#endif

/* Initializes the IWDG */
void WatchdogInit(void) {

    /* 
        Watchdog freq. is 32 kHz
        Prescaler: Min_Value = 4 and Max_Value = 256
        Reload: Min_Data = 0 and Max_Data = 0x0FFF
        TimeOut in seconds = (Reload * Prescaler) / Freq.
        MinTimeOut = (4 * 1) / 32000 = 0.000125 seconds (125 microseconds)
        MaxTimeOut = (256 * 4096) / 32000 = 32.768 seconds
    */
    hiwdg.Instance = IWDG;
    hiwdg.Init.Prescaler = IWDG_PRESCALER_256; 
    hiwdg.Init.Reload = 625;                
    HAL_IWDG_Init(&hiwdg);

}

/* Starts the IWDG. */
void WatchdogStart(void) {
    HAL_IWDG_Start(&hiwdg);
}

/* Refreshes the IWDG. */
void WatchdogRefresh(void) {
    HAL_IWDG_Refresh(&hiwdg);
}

void WatchdogStatus(void) {
    switch (HAL_IWDG_GetState(&hiwdg)) {
        case HAL_IWDG_STATE_RESET:       /*!< IWDG not yet initialized or disabled */
            printf("IWDG not yet initialized or disabled\r\n");
            break;
        case HAL_IWDG_STATE_READY:       /*!< IWDG initialized and ready for use   */
            printf("IIWDG initialized and ready for use\r\n");
            break;
        case HAL_IWDG_STATE_BUSY:        /*!< IWDG internal process is ongoing     */
            printf("IWDG internal process is ongoing\r\n");
            break;
        case HAL_IWDG_STATE_TIMEOUT:     /*!< IWDG timeout state                   */
            printf("IWDG timeout state\r\n");
            break;
        case HAL_IWDG_STATE_ERROR:       /*!< IWDG error state                     */
            printf("IWDG error state\r\n");
            break;
        default: 
            printf("Unknown state\r\n");
            break;
    }
}

int main() {    
    int sec = 0;
    int min = 0;
    int hour = 0;
    int day = 0;
    int date = 0;
    int month = 0;
    int year = 0;
    int i = 0; 
    
    WatchdogInit(); // init a watchdog with 5 seconds timeout
    WatchdogStatus();
    WatchdogStart();
    
    while (true) {
        ds1307.gettime(&sec, &min, &hour, &day, &date, &month, &year);
        printf("%02d/%02d/%04d %02d:%02d:%02d\r\n", day, month, year, hour, min, sec);

        if (i == 10) {
            wait(10);
        }
        WatchdogRefresh();
        i++;
        wait(1); 
    }
}