// Display RealDateTime on LCD1602 KeyPad
#include "mbed.h"
#include "TextLCD.h"    // LCD1602
#include "Rtc_Ds1307.h" // RTC

Rtc_Ds1307 rtc(PTE0, PTE1);
TextLCD lcd(PTA13, PTD5, PTA4, PTA5, PTC8, PTC9);
DigitalOut blueLED(LED_BLUE);
AnalogIn keys(PTB0);

// diplay text on LCD
void textLCD(char *text, int line) {
    char tmpBuf[16];
    for (int i = 0; i < 16; i++) tmpBuf[i] = 0x20;
    for (int i = 0; i < strlen(text); i++) {
        if (i <= 16) tmpBuf[i] = text[i];
    }
    
    lcd.locate(0, line);
    lcd.printf(tmpBuf);
}

int main(){
    char tmpString[16];
    int tmpSec = 0;
    char bootSymbols[17];   
    char booting = 0x00;
    char countDown = 0;
    lcd.cls();
    Rtc_Ds1307::Time_rtc tm = {};
    int iKey = 0;
    int oldiKey = 0;
    
    for (int i = 0; i <= 16; i++) bootSymbols[i] = 0x00;
    textLCD("RTC_LCD Example", 0);
    
    while(true){
        if (countDown >= 17){
            booting = 0x01;
        }
        if (booting == 0x00){
            for (int i = 0; i < countDown; i++){
                bootSymbols[i] = 0xff;
            }
            sprintf(tmpString, "%s", bootSymbols);
            textLCD(tmpString, 1);
            countDown++;
            wait(0.1);
        } else {        
            if(rtc.getTime(tm)){
                sprintf(tmpString, "%02d:%02d:%02d  %d/%d/%d", tm.hour, tm.min, tm.sec, tm.date, tm.mon, (tm.year % 100));
                textLCD(tmpString, 0);
                
                iKey = keys.read_u16();
                if (iKey != oldiKey) {
                    
                    oldiKey = iKey;
                    
                    if ((iKey > 0) &&(iKey < 1000)) {
                        sprintf(tmpString, "Key %c LEFT  %4x", char(0x7e), iKey);
                    } else if ((iKey >  1000) && (iKey < 15000)) {
                        sprintf(tmpString, "Key %c UP    %4x", char(0x7e), iKey);
                    } else if ((iKey > 15000) && (iKey < 40000)) {
                        sprintf(tmpString, "Key %c DOWN  %4x", char(0x7e), iKey);
                    } else if ((iKey > 40000) && (iKey < 60000)) {
                        sprintf(tmpString, "Key %c RIGHT %4x", char(0x7e), iKey);
                    } else {
                        sprintf(tmpString, "Key %c NONE  %4x", char(0x7e), iKey);
                    }
                        
                    
                    textLCD(tmpString, 1);
                }
                blueLED = (tmpSec != tm.sec) ? 0 : 1;
                tmpSec = tm.sec;
            }
        }
        
    }
}    