#include "mbed.h"
#include "sx9500.h"

#define IRQ_EN 1

I2C i2c0(I2C_SDA , I2C_SCL );    // I2C_SCL = PTC10,  I2C_SDA = PTC11,
SX9500 touch(i2c0, PTA24, PTA9); // TOUCH_TXEN = PTA24, TOUCH_INT = PTA9
DigitalOut touch_rst(PTA2,1);    // TOUCH_RST = PTA2

bool read_en = true;

#if(IRQ_EN)
// InterruptIn SW1(PTE28);
InterruptIn touch_int(PTA9);
/* LEDS */
DigitalOut led_red(LED_RED, 1);

void touch_irq()
{
        read_en = true;
        led_red = !led_red;
}
#endif // IRQ_EN

void print_state(SX9500_TouchState_t ts)
{
            if(ts.downPressed)            
                    printf("DOWN\r\n");
            if(ts.rightPressed)
                    printf("RIGHT\r\n");
            if(ts.upPressed)
                    printf("UP\r\n");
            if(ts.leftPressed)
                    printf("LEFT\r\n");            
            if(!ts.downPressed && !ts.rightPressed && !ts.upPressed && !ts.leftPressed )
                    printf("NONE\r\n"); 
}

void touch_service()
{
SX9500_TouchState_t ts;
read_en = false;
ts = touch.read_proximity_sensors();                 
print_state(ts);
// reset interrupt state
touch.service();
}

// main() runs in its own thread in the OS
int main() {    
      
    wait(1);  
    touch.reset();        
    wait(0.3); // wait until the reset has finished
    touch.init();
    wait(0.3);
    touch.set_active(true);    
    wait(0.3);

#if(IRQ_EN)
    touch_int.fall(&touch_irq);
    // SW1.fall(&touch_irq);
    read_en = false;
#endif

    while (true) {      
#if(!IRQ_EN)
            read_en = true;
#endif
            wait(0.3);
            if(read_en)
                touch_service();
    }
}
