/***************************************************************************//**
 * @file food.cpp
 * @brief class for creating a food-like object and keeps track of its momvement
 *******************************************************************************
 * @section License
 * <b>(C) Copyright 2015 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/

#include "food.h"
#include "gecko.h"
#define NFOODPIX 18

const uint8_t food_px_map[NFOODPIX] = {0x02, 0x03, 0x04, 0x11, 0x13, 0x15, 0x20, 0x23, 0x26, 0x30, 0x36, 0x40, 0x46, 0x51, 0x55, 0x62, 0x63, 0x64};
Food::Food(): x(5), y(5){};

bool Food::isEaten(Gecko &gck){
	return gck.headOccupiesTile(x, y);
}

void Food::reset(ColorMemLCD &display, const Gecko &gck)
{
	this->remove(display);
	x = rand()%BOARD_WIDTH;
	y = rand()%BOARD_HEIGHT;

	while (gck.occupiesTile(x,y))
	{
		x = rand()%BOARD_WIDTH;
		y = rand()%BOARD_HEIGHT;
	}
	this->draw(display);
}

void Food::draw(ColorMemLCD &display)
{
#if(MULTI_UPDATE)
		display.window( x*STEPSIZE + BOARDERWIDTH/2 -1, 
				(y+TOPEDGE)*STEPSIZE + BOARDERWIDTH/2, 
				 STEPSIZE+1,
				STEPSIZE );
#endif	

	for (int i=0;i<NFOODPIX;i++)
	{
		display.pixel(x*STEPSIZE + BOARDERWIDTH/2 + static_cast<uint8_t>( food_px_map[i] & 0xF), \
				(y+TOPEDGE)*STEPSIZE + BOARDERWIDTH/2 + static_cast<uint8_t>( (food_px_map[i] >> 4) & 0xF), Black);
	}

#if(MULTI_UPDATE)
	display.update();
#endif

}

void Food::remove(ColorMemLCD &display)
{
#if(MULTI_UPDATE)
	display.window( x*STEPSIZE + BOARDERWIDTH/2 -1, 
				(y+TOPEDGE)*STEPSIZE + BOARDERWIDTH/2, 
				 STEPSIZE+1,
				STEPSIZE );
#endif

	for (int i=0;i<NFOODPIX;i++)
		{
			display.pixel(x*STEPSIZE + BOARDERWIDTH/2 +static_cast<uint8_t>(food_px_map[i] & 0xF), \
					(y+TOPEDGE)*STEPSIZE + BOARDERWIDTH/2 + static_cast<uint8_t>((food_px_map[i] >> 4) & 0xF), BACKGROUND_COLOR);
		}

#if(MULTI_UPDATE)
	display.update();
#endif

}


