/***************************************************************************//**
 * @file settings.h
 * @settings file for Hungry Gecko program
 ******************************************************************************/
#ifndef SETTINGS_H_
#define SETTINGS_H_
#include "LCDSettings.h"
#include "ColorMemLCD.h"

#define MAXLENGTH 255
#define STEPSIZE 7

/*  Define board limits, note that the display height and display width is 128
 * This particlular choice leads to 255 STEPSIZE x STEPSIZE tiles. Thus,
 * the tile number can be stored in 1 uint8_t
 * */
#define TOPEDGE 3
#define BOARD_HEIGHT 15
#define BOARD_WIDTH 16
#define BOARDERWIDTH (DISPLAY_WIDTH - STEPSIZE*BOARD_WIDTH)

#define FOREGROUND_COLOR LCD_COLOR_BLACK
#define BACKGROUND_COLOR LCD_COLOR_GREEN // LCD_COLOR_WHITE

#define MULTI_UPDATE 0
#define TICKER_EN    1
#define TOUCH_EN     1

/* Define allowed direction to move */
typedef enum{
    LEFT=0, RIGHT, UP, DOWN
} Direction;

#endif /* SETTINGS_H_ */