/***************************************************************************//**
 * @file food.h
 * @brief class for creating a food-like object and keeps track of its momvement
 *******************************************************************************
 * @section License
 * <b>(C) Copyright 2015 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/

#include "mbed.h"
#include "settings.h"
// #include "LS013B7DH03.h"

class Gecko; // Forward declaration
#ifndef FOOD_H_
#define FOOD_H_
/* Pixel map for the food
 * 4 most significant bits y-crd, 4 least significant bits x-crd
 * The upper left corner of the part is asigned coordinates (x,y)=(0,0)
 */
class Food{
public:
	Food();
	bool isEaten(Gecko &gck);
	void reset(ColorMemLCD &display, const Gecko &gck);
	void draw(ColorMemLCD &display);

private:
	uint8_t x;
	uint8_t y;
	void remove(ColorMemLCD &display);
};


#endif /* FOOD_H_ */

