/***************************************************************************//**
 * @file gecko.h
 * @brief class for creating a gecko-like object and keeps track of its momvement
 *******************************************************************************
 * @section License
 * <b>(C) Copyright 2015 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/
 
// #include "LS013B7DH03.h"
#include "settings.h"
#include "asymmetricPart.h"

class Gecko{
  private:
      uint8_t _position[MAXLENGTH];
      uint8_t _last;
      uint8_t _length;

      asymmetricPart _head;

      void drawPart(ColorMemLCD &display, uint8_t x, uint8_t y) const;
      void removePart(ColorMemLCD &display, uint8_t x, uint8_t y) const;

    public:
        Gecko();

        /* Moves the snake and redraws it on the display */
        void move(ColorMemLCD &display, Direction dir);

        /* Redraw the entire snake */
         void draw(ColorMemLCD &display) const;

        /* Check if the snake has collides with itself */
        bool selfCollision() const;

        /* Increases the length of the snake by one STEPSIZE x STEPSIZE tile */
        void increaseLength(ColorMemLCD &display, Direction dir);

        /* Checks if the head of the snake occupies a STEP */
        bool headOccupiesTile(uint8_t x, uint8_t y) const;

        /* Chech if the snake occupies a STEPSIZE x STEPSIZE tile */
        bool occupiesTile(uint8_t x, uint8_t y) const;

        /* Get coordinates */
        uint8_t getX(uint8_t indx) const;
        uint8_t getY(uint8_t indx) const;
};


