/* Copyright (c) 2015 NXP Semiconductors. MIT License
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#include "FXAS21002.h"
#include "FXOS8700.h"  
#include "MPL3115.h" 
#include "mbed.h"
 
// Initialize Serial port
//Serial pc(USBTX, USBRX);

// Initialize pins for I2C communication for sensors. Set jumpers J6,J7 in FRDM-STBC-AGM01 board accordingly.
//    I2C_SCL = PTC10,  I2C_SDA = PTC11,
FXOS8700  accel(I2C_SDA , I2C_SCL );
FXOS8700    mag(I2C_SDA , I2C_SCL );
FXAS21002  gyro(I2C_SDA , I2C_SCL );
MPL3115 mpl3115(I2C_SDA , I2C_SCL );

#define SHORT_WAIT 0.1
#define LONG_WAIT  1.0
     
int main()
{     
 
// Configure Accelerometer FXOS8700, Magnetometer FXOS8700 & Gyroscope FXAS21002
    accel.accel_config();
    mag.mag_config();
    gyro.gyro_config();
    mpl3115.MPL3115_config();
 
    //pc.baud(115200);
    
    float accel_data[3];
    float accel_rms=0.0;
    float mag_data[3];
    float mag_rms=0.0;
    float gyro_data[3];
    float gyro_rms=0.0;
    float alt_data[3];
    float alt_rms=0.0;
       
    printf("\n\rBegin Data Acquisition....\n\r");
    wait(5.0);    
    
    while(1)
    {
      accel.acquire_accel_data_g(accel_data);
      wait(SHORT_WAIT);
      printf("Accelleration: X:%4.2f, Y:%4.2f, Z:%4.2f\n\r",accel_data[0],accel_data[1],accel_data[2]);
      accel_rms = sqrt(((accel_data[0]*accel_data[0])+(accel_data[1]*accel_data[1])+(accel_data[2]*accel_data[2]))/3);
      printf("\n\rAccelleration RMS: %4.2f\n\r",accel_rms);

      mag.acquire_mag_data_uT(mag_data);
      printf("Magnetics readings: X:%4.2f, Y:%4.2f, Z:%4.2f\n\r",mag_data[0],mag_data[1],mag_data[2]);
      mag_rms = sqrt(((mag_data[0]*mag_data[0])+(mag_data[1]*mag_data[1])+(mag_data[2]*mag_data[2]))/3);
      printf("Magnetic RMS: %4.2f\n\r",mag_rms);
      wait(SHORT_WAIT);
      
      gyro.acquire_gyro_data_dps(gyro_data);
      printf("Gyroscope readings: X:%4.2f, Y:%4.2f, Z:%4.2f\n\r",gyro_data[0],gyro_data[1],gyro_data[2]);
      gyro_rms = sqrt(((gyro_data[0]*gyro_data[0])+(gyro_data[1]*gyro_data[1])+(gyro_data[2]*gyro_data[2]))/3);
      printf("Gyroscopic RMS: %4.2f\n\r",gyro_rms);
      wait(SHORT_WAIT);
      
      mpl3115.acquire_MPL3115_data_Altitude_in_m(alt_data);
      printf("Altitude: \t%f\n\r",alt_data[0]);
      alt_rms = sqrt(((alt_data[0]*alt_data[0])+(alt_data[1]*alt_data[1])+(alt_data[2]*alt_data[2]))/3);
      printf("Altitude RMS: %4.2f\n\r",alt_rms);
      wait(SHORT_WAIT);

      wait(LONG_WAIT);
         
     }
      
}
