#include "mbed.h"
#include "TSL2572Sensor.h"

static TSL2572Sensor tsl2572(I2C_SDA, I2C_SCL);

// main() runs in its own thread in the OS
int main() {
    uint8_t id;
    float lux;
    
    // make sure to check the return values (should be 0)
    tsl2572.init();
    tsl2572.enable();
    
    while (true) {           
        tsl2572.read_id(&id);
        printf("TSL2572 light intensity ID = 0x%X\r\n", id);

        tsl2572.read_ambient_light(&lux);
        printf("TSL2572: [lght] %.2f lux\r\n", lux);  
        wait(0.5);   
    }
}