#include "sx9500.h"

#define SX9500_I2C_ADDRESS                          0x50    //0x28


SX9500::SX9500(I2C& r, PinName en_pin, PinName nirq_pin) : m_i2c(r), m_txen(en_pin), m_nirq(nirq_pin)
{
    m_nirq.mode(PullUp);    // no pullup on board?
    RegProxCtrl0.octet = read_single(SX9500_REG_PROXCTRL0);
}

SX9500::~SX9500()
{
}

void SX9500::reset()
{
    write(SX9500_REG_RESET, SX9500_RESET_CMD);
}

void SX9500::print_sensor(char CSn)
{
    uint8_t buf[2];
    
    write(SX9500_REG_SENSORSEL, CSn);
    
    read(SX9500_REG_USEMSB, buf, 2);
    printf("%d useful:0x%02x%02x\r\n", CSn, buf[0], buf[1]);
    
    read(SX9500_REG_AVGMSB, buf, 2);
    //printf("%d   avg:0x%02x%02x\r\n", CSn, buf[0], buf[1]);
    
    read(SX9500_REG_DIFFMSB, buf, 2);
    // printf("%d  diff:0x%02x%02x\r\n", CSn, buf[0], buf[1]);    
}


/*
 * Copyright (c) 2018 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

uint8_t SX9500::init(void)
{
    uint8_t lenRegTable = sizeof(sx9500_i2c_reg_setup) / sizeof(smtc_reg_data_t);
    uint8_t val;
    uint8_t i = 0;    
    
    // read IRQSRC to release NIRQ pin
    read(SX9500_REG_IRQSRC, &val,1);
    
    while (i < lenRegTable)
    {
        /* Write all registers/values contained in i2c_reg */
        write(sx9500_i2c_reg_setup[i].reg, sx9500_i2c_reg_setup[i].val);
        
        /* Read back value from register and verify write */
        val = read_single(sx9500_i2c_reg_setup[i].reg);
        
        if (val != sx9500_i2c_reg_setup[i].val)
        {
            return SX9500_INTERNAL_ERROR;
        }

        i++;
    }

return SX9500_SUCCESS;

}

/*
 * END Copyright (c) 2018 NXP
 *
*/

SX9500_TouchState_t SX9500::read_proximity_sensors()
{
    SX9500_TouchState_t touchState;       
    RegStat_t prox;
        
    read(SX9500_REG_STAT, &prox.octet, 2);

    memset((void *)&touchState, 0, sizeof(SX9500_TouchState_t));
    if(prox.octet > 0)
    {
            if(prox.bits.proxstat0)
              touchState.downPressed = true;
                        
            if(prox.bits.proxstat1)
              touchState.rightPressed = true;
            
            if(prox.bits.proxstat2)            
              touchState.upPressed = true;
            
            if(prox.bits.proxstat3)            
              touchState.leftPressed = true;                    
    }
       
    return touchState;
}

void SX9500::write(uint8_t addr, uint8_t data)
{
    uint8_t cmd[2];
    
    cmd[0] = addr;
    cmd[1] = data;

    if (m_i2c.write(SX9500_I2C_ADDRESS, (char *)cmd, 2))
        printf("SX9500 write-fail\n");
}

void SX9500::read(uint8_t addr, uint8_t *dst_buf, int length)
{
    char cmd[2];

    cmd[0] = addr;
    if (m_i2c.write(SX9500_I2C_ADDRESS, cmd, 1, true))
        printf("SX9500 write-fail\n");
    if (m_i2c.read(SX9500_I2C_ADDRESS, (char *)dst_buf, length))
        printf("SX9500 read-fail\n");
}

uint8_t SX9500::read_single(uint8_t addr)
{
    char cmd[2];

    cmd[0] = addr;
    if (m_i2c.write(SX9500_I2C_ADDRESS, cmd, 1, true))
        printf("SX9500 write-fail\n");
    if (m_i2c.read(SX9500_I2C_ADDRESS, cmd, 1))
        printf("SX9500 read-fail\n");

    return cmd[0];
}

bool SX9500::get_active()
{
    if (m_txen.read())
        return true;
    else
        return false;
}
    
void SX9500::set_active(bool en)
{
    if (en) {
        m_txen = 1;
    } else {
        /* lowest power (non)operation */
        m_txen = 0;
        write(SX9500_REG_PROXCTRL0, 0);  // turn off all sensor pins
    }
}

void SX9500::service()
{
    if (m_nirq.read())
        return;
        
    RegIrqSrc.octet = read_single(SX9500_REG_IRQSRC);

    /*
    printf("95irq:");
    if (RegIrqSrc.bits.conv_done) {
        printf("conv_done:\r\n");
        print_sensor(0);
        print_sensor(1);
    }
    if (RegIrqSrc.bits.comp_done) {
        printf("comp_done ");
    }
    if (RegIrqSrc.bits.far || RegIrqSrc.bits.close) {
        RegStat_t stat;
        printf("stat ");
        stat.octet = read_single(SX9500_REG_STAT);
        if (stat.bits.proxstat0)
            printf("cs0 ");
        if (stat.bits.proxstat1)
            printf("cs1 ");
    }

    if (RegIrqSrc.bits.reset) {
        printf("reset ");
    }
    
    printf("\r\n");
    */
}

