#include "mbed.h"
#include "PidController.h"

PidController::PidController(){
    elapsedTime =0;
    mode = MANUAL;
    }
    
float PidController::Calculate(float SP, float PV) 
    {
        float CV;                   //(mm/s) Control Variable
        float ProportionalAction;
        float IntegralAction;       // Integral Contribution to Output
        float DerivativeAction;     // Derivative Contribution to Output
    
        if (mode == MANUAL)
        {   
            CV = SP;                    //Write Directly to Output
            accumError = 0;
            prevError = 0;
        }
        else 
        {   
            //Calc error
            error = SP - PV; 
            ProportionalAction =  K_p*error ;
            IntegralAction = K_i*(accumError + error);
            DerivativeAction = K_d*(error - prevError);
            
            //-- PID Calculation
            if (SP)
            { 
                CV =  bias + ProportionalAction + IntegralAction + DerivativeAction;
                if (CV>0) {CV = sqrt(CV);}
                else if (CV<0)
                {
                    CV = sqrt(CV*-1.0);
                    CV = CV*-1.0;
                    }
            }
            else 
            {
                CV= 0;
                accumError = 0;
            }
            
            //-- Only allow the Controller to integrate if the output isnt saturated
            if ((CV < maxLimit) || (CV > minLimit)){accumError += error;}

            //-- Save Current Input for Next Loop
            prevError = error;
        }
        
        //Check to See Output is Within Limits
        if (CV > maxLimit){CV= maxLimit;}
        if (CV < minLimit){CV= minLimit;}
           
        //-- Make message to send to GUI
        if (collectDiagnostics)//{BuildDiagMessage(SP,PV, CV, K_p*error, IntegralAction, DerivativeAction);}
        {
            int_to_byte(diagMsg, elapsedTime);
            float_to_byte(diagMsg +2, &SP);
            float_to_byte(diagMsg +6, &PV);
            float_to_byte(diagMsg +10, &CV);
            float_to_byte(diagMsg +14, &ProportionalAction);
            float_to_byte(diagMsg +18, &IntegralAction);
            float_to_byte(diagMsg +22, &DerivativeAction);
            }
        
        return CV;
    }

void PidController::UpdateSettings(float Bias, float PropGain, float IntGain, float DiffGain, float OutputMin, float OutputMax){
    bias = Bias;
    K_p = PropGain;
    K_i = IntGain;
    K_d = DiffGain;
    minLimit = OutputMin;
    maxLimit = OutputMax;
    return;
    }

void PidController::UpdateSettings(float OutputMin, float OutputMax){
    minLimit = OutputMin;
    maxLimit = OutputMax;
    return;
    }


void PidController::StartDiag(void){
    elapsedTime =0;
    collectDiagnostics = true;
    return;
    }

void PidController::EndDiag(void){
    collectDiagnostics = false;
    return;
    }

void PidController::GetDiagnosticsMessage(char *data){
    memcpy(data, &diagMsg, 27 );
    return;
    }
//-- Helper Functions
    
//-- Convert floating point to byte array
void PidController::float_to_byte(char *data, float *val) {
      memcpy(data, val, sizeof(float)); 
}

//-- Convert integer to byte array
void PidController::int_to_byte(char *data, uint16_t val) {
      memcpy(data, &val, sizeof val); 
}
