/* mbed TextOLED Library, for a 4-bit LCD based on Winstar WEH000000 series
 *   Originl: http://mbed.org/users/simon/libraries/TextLCD/latest
 *   Modified by Suga
 */
/* mbed TextLCD Library, for a 4-bit LCD based on HD44780
 * Copyright (c) 2007-2010, sford, http://mbed.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "TextOLED.h"
#include "mbed.h"

TextOLED::TextOLED(PinName rs, PinName e, PinName d4, PinName d5,
                 PinName d6, PinName d7, LCDType type) : _rs(rs),
        _e(e), _d(d4, d5, d6, d7),
        _type(type) {
    int i;

    _rs = 0;            // command mode
    _e  = 1;

    wait_ms(100);        // Wait 15ms to ensure powered up

    for (i = 0; i < 5; i ++) {
        write4bit(0);
    }
/*
    write4bit(0x3);     // 8-bit mode
    write4bit(0x3);     // 8-bit mode
    write4bit(0x0);
*/
    write4bit(0x2);     // 4-bit mode

    writeCommand(0x28); // Function set 001 BW N F - -
    writeCommand(0x0C); // 0000 1 D C B
    writeCommand(0x06); // Entry mode : 0000 01 I/D S
    writeCommand(0x10); // Cursor and Display Shift 0001 S/C R/L 0 0
    writeCommand(0x17); // DCDC on
    wait_ms(10);
    writeCommand(0x02); // Home
    cls();
}

void TextOLED::character(int column, int row, int c) {
    int a = address(column, row);
    writeCommand(a);
    writeData(c);
}

void TextOLED::cls() {
    writeCommand(0x01); // cls, and set cursor to 0
    wait_ms(10);     // This command takes 1.64 ms
    locate(0, 0);
}

void TextOLED::locate(int column, int row) {
    _column = column;
    _row = row;
}

int TextOLED::_putc(int value) {
    if (value == '\n') {
        _column = 0;
        _row++;
        if (_row >= rows()) {
            _row = 0;
        }
    } else {
        character(_column, _row, value);
        _column++;
        if (_column >= columns()) {
            _column = 0;
            _row++;
            if (_row >= rows()) {
                _row = 0;
            }
        }
    }
    return value;
}

int TextOLED::_getc() {
    return -1;
}

void TextOLED::write4bit(int value) {
    _e = 1;
    _d = value;
    wait_us(1);
    _e = 0;
    wait_ms(10);
}

void TextOLED::writeByte(int value) {
    _e = 1;
    _d = (value >> 4) & 0x0f;
    wait_us(1);
    _e = 0;
    wait_us(1);
    _e = 1;
    _d = value & 0x0f;
    wait_us(1);
    _e = 0;
    wait_us(50);
}

void TextOLED::writeCommand(int command) {
    _rs = 0;
    wait_us(1);
    writeByte(command);
}

void TextOLED::writeData(int data) {
    _rs = 1;
    wait_us(1);
    writeByte(data);
}

int TextOLED::address(int column, int row) {
    switch (_type) {
        case LCD20x4:
            switch (row) {
                case 0:
                    return 0x80 + column;
                case 1:
                    return 0xc0 + column;
                case 2:
                    return 0x94 + column;
                case 3:
                    return 0xd4 + column;
            }
        case LCD16x2B:
            return 0x80 + (row * 40) + column;
        case LCD16x2:
        case LCD20x2:
        case LCD8x2:
        default:
            return 0x80 + (row * 0x40) + column;
    }
}

int TextOLED::columns() {
    switch (_type) {
        case LCD8x2:
            return 8;
        case LCD20x4:
        case LCD20x2:
            return 20;
        case LCD16x2:
        case LCD16x2B:
        default:
            return 16;
    }
}

int TextOLED::rows() {
    switch (_type) {
        case LCD20x4:
            return 4;
        case LCD16x2:
        case LCD16x2B:
        case LCD20x2:
        case LCD8x2:
        default:
            return 2;
    }
}

void TextOLED::cursor (bool flg) {
    if (flg) {
        writeCommand(0x0F); // 0000 1 D C B
    } else {
        writeCommand(0x0C); // 0000 1 D C B
    }
}
