
#ifndef SOFTSPI_h
#define SOFTSPI_h

#include <mbed.h>

#define LSB_FIRST 0
#define MSB_FIRST 1


//namespace twtg {

class SoftSPI
{
  public:

    SoftSPI(PinName pin_sck, PinName pin_dout, PinName pin_din);

    void attach();
    void detach(void);

    uint8_t write(uint8_t output);
    uint8_t read();

    void writeBulk(uint8_t *src,uint8_t *dst,uint8_t len);
    void readBulk(uint8_t *dst,uint8_t len);
    uint8_t shiftInOutBit(uint8_t bit);

  private:
  
    bool attached;
    DigitalInOut _sck;
    DigitalInOut _dout;
    DigitalInOut _din;
    uint8_t rx[3];
};

//} // namespace twtg

#endif 
