
#include "softSPI.h"
//#include "nrf_delay.h"

//#include "../SEGGER_RTT/SEGGER_RTT.h"
//#define DEBUGL(X) SEGGER_RTT_printf(0, X)
//#define DEBUGF(X,Y) SEGGER_RTT_printf(0, X, Y)

#define LOW                 0
#define HIGH                1

#define SPI_FREQUENCY_HZ    1000000     // SCLK frequency in hz
#define SPI_BITS            8           // Number of bits per SPI frame (4 - 16)
#define SPI_MODE            1           // Clock polarity and phase mode (0 - 3):
// mode | POL PHA
// -----+--------
//   0  |  0   0
//   1  |  0   1
//   2  |  1   0
//   3  |  1   1

//namespace twtg {

SoftSPI::SoftSPI(PinName pin_sck, PinName pin_dout, PinName pin_din) :
    _sck(pin_sck, PIN_INPUT, PullNone, 0),
    _dout(pin_dout, PIN_INPUT, PullNone, 0),
    _din(pin_din, PIN_INPUT, PullNone, 0)
{
    attached = false;
    return;
}

void SoftSPI::attach()
{
    _sck.output();
    _dout.output();
    _din.input();
    attached = true;
    return;
}

void SoftSPI::detach()
{
    _sck.input();
    _dout.input();
    _din.input();
    attached = false;
    return;
}

uint8_t SoftSPI::write(uint8_t  byte)
{
    int8_t i = 0;
    uint8_t out = 0;

    if (!attached)
    {
        return 0;
    }

    for (i = 7; i >= 0; i--)
    {
        out |= (shiftInOutBit(byte >> i) & 0x01) << i;
    }
    return out;
}

uint8_t SoftSPI::read()
{
    return write(0x00);
}


void SoftSPI::writeBulk(uint8_t *src, uint8_t *dst, uint8_t len)
{
    int8_t i = 0;
    for (i = 0; i < len; i++)
    {
        dst[i] = write(src[i]);
    }
}

void SoftSPI::readBulk(uint8_t *dst, uint8_t len)
{
    uint8_t tx[len];
    writeBulk(tx, dst, len);

}


uint8_t SoftSPI::shiftInOutBit(uint8_t bit)
{
    _sck.write(HIGH);
    //if(_pin_dout != NC) _dout->write(bit);
    //nrf_delay_us(1);
    wait_us(1);
    uint8_t val = _din.read();
    _sck.write(LOW); // clock in data
    //nrf_delay_us(1);
    wait_us(1);
    return val;
}
