/*
  ADS1232.h - Library for reading from a ADS1232 24-bit ADC.
  Created by Jeffrey M. Kubascik, June 28, 2016.
  Released into the public domain.
*/
#ifndef ADS1232_h
#define ADS1232_h

#include <mbed.h>


typedef void (*cbptr_t)(void);

typedef enum
{
    IDLE,           // No operation currently ongoing
    CLEARING,       // In the process of clearing the display
    WRITING,        // In the process of sending a display update
    WAIT_CLEAR,     // Going to clear after CS pin timeout
    WAIT_WRITE,     // Going to write after CS pin timeout
    TRANSFERS_DONE, // Last transfer in progress
    DONE            // Done with transmission, waiting for CS pin to become high
} ADS1232_state_t;

typedef enum
{
    GAIN1 = 1,
    GAIN2,
    GAIN64,
    GAIN128
} Gain;

typedef enum
{
    SLOW = 0,
    FAST
} Speed;

typedef enum
{
    AIN1 = 0,
    AIN2,
    TEMP
} Channel;

//namespace twtg {

class ADS1232
{
public:

    //ADS1232(PinName pin_sck, PinName pin_din_rdy, PinName pin_pdwn, PinName pin_gain0, PinName pin_gain1, PinName pin_speed, PinName pin_a0, PinName pin_temp);
    ADS1232(PinName pin_sck, PinName pin_din_rdy, PinName pin_pdwn);

    void attach(void);
    void detach(void);

    // void setGain(Gain gain);
    // void setSpeed(Speed speed);
    // void setChannel(Channel channel);

    int32_t read(void);

private:
    void waitDataReady(void);

    PinName _pin_sck;
    PinName _pin_din_rdy;
    PinName _pin_pdwn;
    // PinName _pin_gain0;
    // PinName _pin_gain1;
    // PinName _pin_speed;
    // PinName _pin_a0;
    // PinName _pin_temp;

    Channel currentChannel;
    Gain currentGain;
    Speed currentSpeed;

    bool configChanged;
};

//} // namespace twtg

#endif /* #ifndef ADS1232_h */
