/*
  ADS1232.cpp - Library for reading from a ADS1232 24-bit ADC.
  Created by Jeffrey M. Kubascik, June 28, 2016.
  Released into the public domain.
*/

// https://os.mbed.com/teams/SiliconLabs/code/MemoryLCD/file/tip/LS013B7DH03.cpp/
// https://os.mbed.com/teams/SiliconLabs/code/MemoryLCD/file/0f8ae10b308d/LS013B7DH03.h/

#include "ADS1232.h"
#include "softSPI.h"

//#include "../SEGGER_RTT/SEGGER_RTT.h"
//#define DEBUGL(X) SEGGER_RTT_printf(0, X)
//#define DEBUGF(X,Y) SEGGER_RTT_printf(0, X, Y)

#define LOW                 0
#define HIGH                1

#define SPI_FREQUENCY_HZ    1000000     // SCLK frequency in hz
#define SPI_BITS            8           // Number of bits per SPI frame (4 - 16)
#define SPI_MODE            1           // Clock polarity and phase mode (0 - 3):
// mode | POL PHA
// -----+--------
//   0  |  0   0
//   1  |  0   1
//   2  |  1   0
//   3  |  1   1


//#include "../SEGGER_RTT/SEGGER_RTT.h"
//#define DEBUGL(X) SEGGER_RTT_printf(0, X)
//#define DEBUGF(X,Y) SEGGER_RTT_printf(0, X, Y)

//DigitalInOut _cs;
DigitalOut* _pdwn;
//DigitalOut* _gain0;
//DigitalOut* _gain1;
//DigitalOut* _speed;
//DigitalOut* _a0;
//DigitalOut* _temp;

DigitalIn *_din_rdy;

SoftSPI* spi;

//namespace twtg {

//ADS1232::ADS1232(PinName pin_sck, PinName pin_din_rdy, PinName pin_pdwn, PinName pin_gain0, PinName pin_gain1, PinName pin_speed, PinName pin_a0, PinName pin_temp) :
ADS1232::ADS1232(PinName pin_sck, PinName pin_din_rdy, PinName pin_pdwn) :
    _pin_sck(pin_sck),
    _pin_din_rdy(pin_din_rdy),
    _pin_pdwn(pin_pdwn) //,
    // _pin_gain0(pin_gain0),
    // _pin_gain1(pin_gain1),
    // _pin_speed(pin_speed),
    // _pin_a0(pin_a0),
    // _pin_temp(pin_temp)
{
    spi = new SoftSPI(_pin_sck, NC, _pin_din_rdy);
    _pdwn = new DigitalOut(_pin_pdwn, LOW);
    // _gain0 = new DigitalOut(_pin_gain0, LOW);
    // _gain1 = new DigitalOut(_pin_gain1, LOW);
    // _speed = new DigitalOut(_pin_speed, LOW);
    // _a0 = new DigitalOut(_pin_a0, LOW);
    // _temp = new DigitalOut(_pin_temp, LOW);
    _din_rdy = new DigitalIn(_pin_din_rdy, PullNone);
    configChanged = false;

    currentChannel = AIN1;
    currentGain = GAIN128; // according to schematics
    currentSpeed = SLOW;

    return;
}

void ADS1232::attach(void)
{
    if (_pin_pdwn != NC) _pdwn->write(HIGH);
    spi->attach();
    configChanged = true;

    // setChannel(currentChannel);
    // setGain(currentGain);
    // setSpeed(currentSpeed);
    return;
}

void ADS1232::detach(void)
{
    if (_pin_pdwn != NC) _pdwn->write(LOW);
    // if (_pin_gain0 != NC) _gain0->write(LOW);
    // if (_pin_gain1 != NC) _gain1->write(LOW);
    // if (_pin_speed != NC) _speed->write(LOW);
    // if (_pin_a0 != NC) _a0->write(LOW);
    // if (_pin_temp != NC) _temp->write(LOW);
    spi->detach();
    return;
}

// void ADS1232::setGain(Gain gain)
// {
//     if (gain == currentGain)
//     {
//         return;
//     }

//     switch(gain)
//     {
//         case GAIN1:
//         {
//             if(_pin_gain1 != NC)
//             {
//                 _gain1->write(LOW);
//             }
//             if(_pin_gain0 != NC)
//             {
//                 _gain0->write(LOW);
//             }
//             break;
//         }
//         case GAIN2:
//         {
//             if(_pin_gain1 != NC)
//             {
//                 _gain1->write(LOW);
//             }
//             if(_pin_gain0 != NC)
//             {
//                 _gain0->write(HIGH);
//             }
//             break;
//         }
//         case GAIN64:
//         {
//             if(_pin_gain1 != NC)
//             {
//                 _gain1->write(HIGH);
//             }
//             if(_pin_gain0 != NC)
//             {
//                 _gain0->write(LOW);
//             }
//             break;
//         }
//         case GAIN128:
//         {
//             if(_pin_gain1 != NC)
//             {
//                 _gain1->write(HIGH);
//             }
//             if(_pin_gain0 != NC)
//             {
//                 _gain0->write(HIGH);
//             }
//             break;
//         }
//     }
//     currentGain = gain;
//     configChanged = true;
//     return;
// }

// void ADS1232::setSpeed(Speed speed)
// {
//     if (speed == currentSpeed)
//     {
//         return;
//     }

//     if(_pin_speed != NC)
//     {
//         switch(speed)
//         {
//             case SLOW:
//             {
//                 _speed->write(LOW);
//                 break;
//             }
//             case FAST:
//             {
//                 _speed->write(HIGH);
//                 break;
//             }
//         }
//     }

//     currentSpeed = speed;
//     configChanged = true;
//     return;
// }

// void ADS1232::setChannel(Channel channel)
// {
//     if (channel == currentChannel)
//     {
//         return;
//     }

//     switch(channel)
//     {
//         case AIN1:
//         {
//             if(_pin_temp != NC)
//             {
//                 _temp->write(LOW);
//             }
//             if(_pin_a0 != NC)
//             {
//                 _a0->write(LOW);
//             }
//             break;
//         }
//         case AIN2:
//         {
//             if(_pin_temp != NC)
//             {
//                 _temp->write(LOW);
//             }
//             if(_pin_a0 != NC)
//             {
//                 _a0->write(HIGH);
//             }
//             break;
//         }
//         case TEMP:
//         {
//             if(_pin_temp != NC)
//             {
//                 _temp->write(HIGH);
//             }
//             if(_pin_a0 != NC)
//             {
//                 _a0->write(LOW);
//             }
//             break;
//         }
//     }

//     currentChannel = channel;
//     configChanged = true;
//     return;
// }

int32_t ADS1232::read(void)
{
    int32_t data = 0;
    uint8_t rx[3] = {0};

    waitDataReady();
    spi->readBulk(rx, 3);
    spi->shiftInOutBit(0x01); // fix last clock

    data = (rx[0] & 0x80) ? (0xFF << 24) : 0; // Extend signed bit
    data |= (int32_t)rx[0] << 16;
    data |= (int32_t)rx[1] <<  8;
    data |= (int32_t)rx[2] <<  0;

    return data;
}

void ADS1232::waitDataReady(void)
{
    // According to the datasheet it doese NOT requires five dummy reads after a channel switch, but from practice it does
    uint8_t fallingEdges = configChanged ? 5 : 1;

    while (fallingEdges > 0)
    {
        // Wait for falling edge
        while (_din_rdy->read() != HIGH);
        while (_din_rdy->read() != LOW);
        fallingEdges--;
    }
}

//} // namespace twtg
