// Conversion Analogique Numérique sur l'entrée A0 (ADC_INTER)
// Diffusion des résultats sur Hyperterminal (9600Bauds) 
#include "mbed.h"
#define VREF 3.3  // Echelle ADC sur 3V3  

AnalogIn pot(A0); // Entrée analogique "pot" sur l'entrée A0 

unsigned short NADC; // Entier NADC 16bits non signé  
float   Vpot;        // Nombre réel Vpot

int main() {
    while(1) {
                NADC = pot.read_u16();      // Acquisition N 
                Vpot = (NADC*VREF)/65535;   // Calcul de Vpot
                printf("NADC = %04X\n\r", NADC);
                printf("NADC = %05D\n\r", NADC);
                
                printf("Tension V = %f\n\n\r", Vpot);
                wait(0.2);  //waits a 200 ms 
    }
}
