/* mbed Microcontroller Library
 TEST DE L'HORLOGE RTCC DS3231 :
 Terminal série + mesures oscilloscope à l'aide du mini breakout RTCC DS3231
*/

#include "mbed.h"

I2C mon_i2c(I2C_SDA, I2C_SCL); // Instantiation de l'objet mon_i2c
// Déclaration des adresses I2C de la RTCC
const int ecr_DS3231 = 0xD0; // 8bit I2C adressage en écriture de la RTCC DS3231
const int lec_DS3231 = 0xD1; // 8bit I2C adressage en lecture de la RTCC DS3231

DigitalOut maled(LED1);
DigitalIn monbouton(USER_BUTTON);

char Reg_RTCC[8] = { 0x00, 0x50, 0x59, 0x23,  0x03, 0x31, 0x12, 0x20 }; // Valeurs pour exemple uniquement
/*   Registres: word.addr, sec., min., heure, N_jr, date, mois, année
     Remarque: le registre seconde vaut ici 0x50 (50 sec)
     Le registre jour vaut 0x03 (ici 3ème jour de la semaine) etc...
     LES VALEURS SONT EN HEXA. CAR LES DONNEES SONT CODEES EN BCD:
     ON PEUT AINSI IDENTIFIER PLUS FACILEMENT LE CONTENU... */

void Init_RTCC(void);
void Ecrire_RTCC(void);
void Lire_RTCC(void);
void Diffuser_RTCC(void);

int main()
{
    maled = 0;     // Exctintion led
    Init_RTCC();   // Ecriture du registre de contrôle... sortie SQW à 1Hz
    Ecrire_RTCC(); // Ecriture des 7 premiers registres pour mise à l'heure et date
    printf("\n\n** Test RTCC **\n\r");
    while (true) {
        maled = 1; // Témoin led
        Lire_RTCC();
        Diffuser_RTCC();
        maled = 0;
        //void rtos :: ThisThread :: sleep_for (100ms); // Tempo 100ms
        wait_ms(100); // tempo 500ms
    }
}

void Init_RTCC()
{
    char data_I2C[2] = { 0x0E, 0x08 };
// 0x0E est l'adresse du registre de contrôle que l'on met à 0x08 (Sortie SQW à 1024Hz (RS2=0 RS1=1))
    mon_i2c.write(ecr_DS3231, data_I2C, 2); // Génère la séquence I2C complète : Start + addr_W + 2 octets + stoP
// REMARQUE: normalement, on devrait avoir un signal 1Hz sur SQW si on écrit 0x00 (RS2=RS1=0)
//           mais j'observe un basculement tous les 14 secondes?
// Par contre, si j'écris 0x18 pour avoir RS1=2 et RS1=1 je mesure bien 8192Hz comme mentionné dans la datasheet
// Idem pour RS2=0 et RS1=1 (0x08) j'obtiens bien 1024Hz

}

void Ecrire_RTCC()
{
    mon_i2c.write(ecr_DS3231, Reg_RTCC, 8); // Génère la séquence I2C complète : Start + addr_W + 8 octets + stoP
}

void Lire_RTCC()
{
    char reg_adress = 0; // Le registre d'adresse pointe celui des secondes
    mon_i2c.write(ecr_DS3231, &reg_adress, 1, true); // Génère la séquence I2C sans le stoP : Start + addr_W + 1 octet
    // Le 4ème argument "true" permet de ne pas générer de stop et donc de démarrer directement
    // la séquence de lecture qui suit sur un "Restart" comme voulu par l'"état de l'art" du bus I2C...
    mon_i2c.read(lec_DS3231, Reg_RTCC+1, 7); // Génère la séquence I2C complète : Start + addr_R + 7 octets (NACK) + stoP
}

void Diffuser_RTCC()
{
    int i;
    /* // Version 1 : Affichage basique non formaté avec passage à la ligne
    printf("H");
    for (i = 3; i >= 1; i--) printf(":%X", Reg_RTCC[i]);
    // REMARQUE: printf(":%02X", Reg_RTCC[i]); ne fonctionne pas pour imposer un format sur deux caractères hexa
    //           contrairement au compilateur CCS...
    printf(" D");
    for (i = 5; i <= 7; i++) printf(":%X", Reg_RTCC[i]);
    printf(" J:%X\n", Reg_RTCC[4]);
    */
    // Version 2 : Affichage formaté avec retour début de ligne sans passage à la ligne
    printf("Heure>");
    for (i = 3; i >= 1; i--) {
        if (Reg_RTCC[i] < 0x10) putchar('0');
        printf("%X", Reg_RTCC[i]);
        if (i > 1) putchar(':');
    }
    printf(" Date>");
    for (i = 5; i <= 7; i++) {
        if (Reg_RTCC[i] < 0x10) putchar('0');
        printf("%X", Reg_RTCC[i]);
        if (i < 7) putchar(':');
    }
    printf(" Jour>");
    printf("%X\r", Reg_RTCC[4]);
}

