/* Test du bargraph sur la carte
 * d'extension NUCLEO-64 BTS1 2020_21
 * CHENILLARD SUR LES 8 LEDS DU BARGRAPH
 * A VALIDER...
 */

#include "mbed.h"
I2C mon_i2c(I2C_SDA, I2C_SCL); // Instantiation de l'objet mon_i2c

// Déclaration des variables globales
const int addr8bit = 0x42; // 8bit I2C adresse en écriture, PCF8574T
                           // A6A5A4A3 A2A1A0R/W = 0100 0010

// main() runs in its own thread in the OS
int main() {
  char i, chenill;

  while (true) {
    chenill = 0xFE; // Initialisation du chenillard (1111 1110)
    for (i = 0; i < 8; i++) {
      mon_i2c.write(addr8bit, &chenill, 1); // Génère la séquence I2C complète :
                                            // Start + Adressage_Write + 1 seul octet + stoP
      chenill = (chenill<<1) + 1 ;          // Décalage à gauche du chenillard + mise à 1 du LSb.
      wait_ms(100); // Tempo entre chaque trame I2C.
    }
  }
}

