#ifndef _SMARTFORMAT_H_
#define _SMARTFORMAT_H_

#include "mbed.h"

const uint16_t SF_DIGITAL_INPUT=3200;
const uint16_t SF_DIGITAL_OUTPUT=3201;
const uint16_t SF_ANALOG_INPUT=3202;
const uint16_t SF_ANALOG_OUTPUT=3203;       
const uint16_t SF_GENERIC_SENSOR=3300;
const uint16_t SF_ILLUMINANCE=3301;
const uint16_t SF_PRESENCE=3302;
const uint16_t SF_TEMPERATURE=3303;
const uint16_t SF_HUMIDITY=3304;
const uint16_t SF_POWER_MEASUREMENT=3305;
const uint16_t SF_ACTUATION=3306;
const uint16_t SF_SET_POINT=3308;
const uint16_t SF_LOAD_CONTROL=3310;
const uint16_t SF_LIGHT_CONTROL=3311;
const uint16_t SF_POWER_CONTROL=3312;
const uint16_t SF_ACCELEROMETER=3313;
const uint16_t SF_MAGNETOMETER=3314;
const uint16_t SF_BAROMETER=3315;
const uint16_t SF_VOLTAGE=3316;
const uint16_t SF_CURRENT=3317;
const uint16_t SF_FREQUENCY=3318;
const uint16_t SF_DEPTH=3319;
const uint16_t SF_PERCENTAGE=3320;
const uint16_t SF_ALTITUDE=3321;
const uint16_t SF_LOAD=3322;
const uint16_t SF_PRESSURE=3323;
const uint16_t SF_DISTANCE=3330;
const uint16_t SF_ENERGY=3331;
const uint16_t SF_DIRECTION=3332;
const uint16_t SF_TIME=3333;
const uint16_t SF_GYROMETER=3334;
const uint16_t SF_COLOUR=3335;
const uint16_t SF_LOCATION=3336;


// Data ID + Data Type + Data Size
#define SF_DIGITAL_INPUT_SIZE       1 // 1 ou 0 (8bits)
#define SF_DIGITAL_OUTPUT_SIZE      1 // 1 ou 0 (8bits)
#define SF_ANALOG_INPUT_SIZE        4 // float 32 bits
#define SF_ANALOG_OUTPUT_SIZE       4 // float 32 bits       
#define SF_GENERIC_SENSOR_SIZE      4 // float 32 bits
#define SF_ILLUMINANCE_SIZE     4 // float 32 bits
#define SF_PRESENCE_SIZE        2
#define SF_TEMPERATURE_SIZE     4 // float 32 bits
#define SF_HUMIDITY_SIZE        4 // float 32 bits
#define SF_POWER_MEASUREMENT_SIZE   4 // float 32 bits
#define SF_ACTUATION_SIZE       4 // float 32 bits
#define SF_SET_POINT_SIZE       4 // float 32 bits
#define SF_LOAD_CONTROL_SIZE        1 // 1 ou 0 (8bits)
#define SF_LIGHT_CONTROL_SIZE       1 // 1 ou 0 (8bits)
#define SF_POWER_CONTROL_SIZE       4 // float 32 bits
#define SF_ACCELEROMETER_SIZE       4 // float 32 bits
#define SF_MAGNETOMETER_SIZE        4 // float 32 bits
#define SF_BAROMETER_SIZE       4 // float 32 bits
#define SF_VOLTAGE_SIZE         4 // float 32 bits
#define SF_CURRENT_SIZE         4 // float 32 bits
#define SF_VOLTAGE_SIZE         4 // float 32 bits
#define SF_FREQUENCY_SIZE       4 // float 32 bits
#define SF_DEPTH_SIZE           4 // float 32 bits
#define SF_PERCENTAGE_SIZE      4 // float 32 bits
#define SF_ALTITUDE_SIZE        4 // float 32 bits
#define SF_LOAD_SIZE            4 // float 32 bits
#define SF_PRESSURE_SIZE        4 // float 32 bits
#define SF_DISTANCE_SIZE        4 // float 32 bits
#define SF_ENERGY_SIZE          4 // float 32 bits
#define SF_DIRECTION_SIZE       4 // float 32 bits
#define SF_TIME_SIZE            4 // float 32 bits
#define SF_GYROMETER_SIZE       4 // float 32 bits
#define SF_COLOUR_SIZE          4 // int 32 bits RGBA
#define SF_LOCATION_SIZE        12 // 3*float - latitude longitude altitude


class SmartFormat {
    public:
        SmartFormat(uint8_t size, uint16_t id);
        ~SmartFormat();
        
        void reset(void);
        uint8_t getSize(void);
        uint8_t* getBuffer(void);
        uint8_t copy(uint8_t* buffer);
        
        uint8_t add_Digital_Input(uint8_t value);
        uint8_t add_Digital_Output(uint8_t value);
        uint8_t add_Analog_Input(float value);
        uint8_t add_Analog_Onput(float value);
        uint8_t add_Generic_Sensor(float value);
        uint8_t add_Illuminance(float value);
        uint8_t add_Presence(int16_t value);
        uint8_t add_Temperature(float value);
        uint8_t add_Humidity(float value);
        uint8_t add_Power_Measurement(float value);
        uint8_t add_Actuation(float value);
        uint8_t add_Set_Point(float value);
        uint8_t add_Load_Control(uint8_t value);
        uint8_t add_Light_Control(uint8_t value);
        uint8_t add_Power_Control(float value);
        uint8_t add_Accelerometer(float value);
        uint8_t add_Magnetometer(float value);
        uint8_t add_Barometer(float value);
        uint8_t add_Voltage(float value);
        uint8_t add_Current(float value);
        uint8_t add_Frequency(float value);
        uint8_t add_Depth(float value);
        uint8_t add_Percentage(float value);
        uint8_t add_Altitude(float value);
        uint8_t add_Load(float value);
        uint8_t add_Pressure(float value);
        uint8_t add_Distance(float value);
        uint8_t add_Energy(float value);
        uint8_t add_Direction(float value);
        uint8_t add_Time(float value);
        uint8_t add_Gyrometer(float value);
        uint8_t add_Colour(int32_t value);
        uint8_t add_Location(float latitude, float longitude, float altitude);
    
    private:
        uint8_t *buffer;
        uint8_t maxsize;
        uint8_t cursor;
        
        
};


#endif