#include "SmartFormat.h"

SmartFormat::SmartFormat(uint8_t size, uint16_t id) : maxsize(size) {
    buffer = (uint8_t*) malloc(size);
    memcpy(buffer, &id, 2);          // copie de l'identifiant du périphérique

    cursor = 2;
}

SmartFormat::~SmartFormat(void) {
    free(buffer);
}

void SmartFormat::reset(void) {
    cursor = 2;
}

uint8_t SmartFormat::getSize(void) {
    return cursor;
}

uint8_t* SmartFormat::getBuffer(void) {
    return buffer;
}

uint8_t SmartFormat::copy(uint8_t* dst) {
    memcpy(dst, buffer, cursor);
    return cursor;
}

uint8_t SmartFormat::add_Digital_Input(uint8_t value) {
    if ((cursor + SF_DIGITAL_INPUT_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_DIGITAL_INPUT, 2);
    cursor += 2;
    buffer[cursor++] = value; 
    return cursor;
}

uint8_t SmartFormat::add_Digital_Output(uint8_t value) {
    if ((cursor + SF_DIGITAL_OUTPUT_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_DIGITAL_OUTPUT, 2);
    cursor += 2;
    buffer[cursor++] = value; 
    return cursor;
}

uint8_t SmartFormat::add_Analog_Input(float value) {
    if ((cursor + SF_ANALOG_INPUT_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_ANALOG_INPUT, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Analog_Onput(float value) {
    if ((cursor + SF_ANALOG_OUTPUT_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_ANALOG_OUTPUT, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Generic_Sensor(float value) {
    if ((cursor + SF_ANALOG_OUTPUT) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_GENERIC_SENSOR, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Illuminance(float value) {
    if ((cursor + SF_ILLUMINANCE_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_ILLUMINANCE, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Presence(int16_t value) {
    if ((cursor + SF_PRESENCE_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_PRESENCE, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 2);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Temperature(float value) {
    if ((cursor + SF_TEMPERATURE_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_TEMPERATURE, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Humidity(float value) {
    if ((cursor + SF_HUMIDITY_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_HUMIDITY, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Power_Measurement(float value) {
    if ((cursor + SF_POWER_MEASUREMENT_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_POWER_MEASUREMENT, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Actuation(float value) {
    if ((cursor + SF_ACTUATION_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_ACTUATION, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Set_Point(float value) {
    if ((cursor + SF_SET_POINT_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_SET_POINT, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Load_Control(uint8_t value) {
    if ((cursor + SF_LOAD_CONTROL_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_LOAD_CONTROL, 2);
    cursor += 2;
    buffer[cursor++] = value; 
    return cursor;
}

uint8_t SmartFormat::add_Light_Control(uint8_t value) {
    if ((cursor + SF_LIGHT_CONTROL) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_DIGITAL_INPUT, 2);
    cursor += 2;
    buffer[cursor++] = value; 
    return cursor;
}

uint8_t SmartFormat::add_Power_Control(float value) {
    if ((cursor + SF_POWER_CONTROL_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_POWER_CONTROL, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Accelerometer(float value) {
    if ((cursor + SF_ACCELEROMETER_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_ACCELEROMETER, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Magnetometer(float value) {
    if ((cursor + SF_MAGNETOMETER_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_MAGNETOMETER, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Barometer(float value) {
    if ((cursor + SF_BAROMETER_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_BAROMETER, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Voltage(float value) {
    if ((cursor + SF_VOLTAGE_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_VOLTAGE, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Current(float value) {
    if ((cursor + SF_CURRENT_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_CURRENT, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Frequency(float value) {
    if ((cursor + SF_FREQUENCY_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_FREQUENCY, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Depth(float value) {
    if ((cursor + SF_DEPTH_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_DEPTH, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Percentage(float value) {
    if ((cursor + SF_PERCENTAGE_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_PERCENTAGE, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Altitude(float value) {
    if ((cursor + SF_ALTITUDE_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_ALTITUDE, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Load(float value) {
    if ((cursor + SF_LOAD_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_LOAD, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Pressure(float value) {
    if ((cursor + SF_PRESSURE_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_PRESSURE, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Distance(float value) {
    if ((cursor + SF_DISTANCE_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_DISTANCE, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Energy(float value) {
    if ((cursor + SF_ENERGY_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_ENERGY, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Direction(float value) {
    if ((cursor + SF_DIRECTION_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_DIRECTION, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Time(float value) {
    if ((cursor + SF_TIME_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_TIME, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Gyrometer(float value) {
    if ((cursor + SF_GYROMETER_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_GYROMETER, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}

uint8_t SmartFormat::add_Colour(int32_t value) {
    if ((cursor + SF_COLOUR_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_COLOUR, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &value, 4);
    cursor += 4;
    return cursor;
}


uint8_t SmartFormat::add_Location(float latitude, float longitude, float altitude) {
    if ((cursor + SF_LOCATION_SIZE) > maxsize) {
        return 0;
    }
    memcpy(&buffer[cursor], &SF_LOCATION, 2);
    cursor += 2;
    memcpy(&buffer[cursor], &latitude, 4);
    cursor += 4;
    memcpy(&buffer[cursor], &longitude, 4);
    cursor += 4;
    memcpy(&buffer[cursor], &altitude, 4);
    cursor += 4;
    return cursor;
}





