#include "mbed.h"
#include "Flipper_Affichage.h"


//GLOBAL VARIABLE
PixelArray px(WS2812_BUF);
// See the program page for information on the timing numbers
// The given numbers are for the K64F
WS2812 ws(D9, WS2812_BUF, 0, 5, 5, 0);
int colorbuffer[NUM_COLORS];
int NbrAfficheur=0;


//Fonctions
void EgalTab(int newTab[][4],int oldTab[][4])
{
    for(int i=0;i<8;i++)
    {
        for(int j=0;j<4;j++)
        {
             newTab[i][j]=oldTab[i][j];
        }
    }
}


void InitDisplay(char Choix1,char Choix2,int color1,int color2,int bande)
{
  int colorbuf[64];
  ws.useII(WS2812::PER_PIXEL); // use per-pixel intensity scaling
  int iTab1[8][4];
  int iTab2[8][4];
  //int colorbuf2[64]={0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000,0x000000};

  ///////////////////////////FIRST LETTERS
  //A
  int iA1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {color1,0,0,color1},
                {color1,color1,color1,color1},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {bande,bande,bande,bande}
            };
        
  //B
  int iB1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,0,0,0},
                {color1,0,0,0},
                {color1,color1,color1,color1},
                {color1,0,0,color1},
                {color1,color1,color1,color1},
                {bande,bande,bande,bande}
            };
            
  //C
  int iC1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {color1,0,0,0},
                {color1,0,0,0},
                {color1,0,0,0},
                {color1,color1,color1,color1},
                {bande,bande,bande,bande}
            };
  
  //D
  int iD1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {0,0,0,color1},
                {0,0,0,color1},
                {color1,color1,color1,color1},
                {color1,0,0,color1},
                {color1,color1,color1,color1},
                {bande,bande,bande,bande}
            };
            
  //E
  int iE1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {color1,0,0,0},
                {color1,color1,color1,color1},
                {color1,0,0,0},
                {color1,color1,color1,color1},
                {bande,bande,bande,bande}
            };
  
  //F
  int iF1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {color1,0,0,0},
                {color1,color1,color1,0},
                {color1,0,0,0},
                {color1,0,0,0},
                {bande,bande,bande,bande}
            };
        
  //G
  int iG1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {color1,0,0,0},
                {color1,0,color1,color1},
                {color1,0,0,color1},
                {color1,color1,color1,color1},
                {bande,bande,bande,bande}
            };
    
  //H
  int iH1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {color1,color1,color1,color1},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {bande,bande,bande,bande}
            };
            
  //I
  int iI1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {0,color1,color1,0},
                {0,color1,color1,0},
                {0,color1,color1,0},
                {color1,color1,color1,color1},
                {bande,bande,bande,bande}
            };
            
  //J
  int iJ1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {0,0,color1,0},
                {0,0,color1,0},
                {0,0,color1,0},
                {color1,color1,color1,0},
                {bande,bande,bande,bande}
            };
            
  //K
  int iK1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,0,0,color1},
                {color1,0,color1,0},
                {color1,color1,0,0},
                {color1,0,color1,0},
                {color1,0,0,color1},
                {bande,bande,bande,bande}
            };
            
  //L
  int iL1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,0,0,0},
                {color1,0,0,0},
                {color1,0,0,0},
                {color1,0,0,0},
                {color1,color1,color1,color1},
                {bande,bande,bande,bande}
            };
            
  //M
  int iM1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,0,0,color1},
                {color1,color1,color1,color1},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {bande,bande,bande,bande}
            };
            
    //N
  int iN1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {0,0,0,0},
                {color1,0,0,color1},
                {color1,color1,0,color1},
                {color1,0,color1,color1},
                {color1,0,0,color1},
                {bande,bande,bande,bande}
            };
            
    //O
  int iO1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {color1,color1,color1,color1},
                {bande,bande,bande,bande}
            };
            
    //P
  int iP1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {color1,0,0,color1},
                {color1,color1,color1,color1},
                {color1,0,0,0},
                {color1,0,0,0},
                {bande,bande,bande,bande}
            };
            
    //Q
  int iQ1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {color1,color1,color1,color1},
                {0,0,0,color1},
                {bande,bande,bande,bande}
            };
            
    //R
  int iR1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {color1,0,0,color1},
                {color1,color1,color1,color1},
                {color1,0,color1,0},
                {color1,0,0,color1},
                {bande,bande,bande,bande}
            };
            
    //s
  int iS1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {color1,0,0,0},
                {color1,color1,color1,color1},
                {0,0,0,color1},
                {color1,color1,color1,color1},
                {bande,bande,bande,bande}
            };
            
    //T
  int iT1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,color1,color1,color1},
                {color1,color1,color1,color1},
                {0,color1,color1,0},
                {0,color1,color1,0},
                {0,color1,color1,0},
                {bande,bande,bande,bande}
            };
            
    //U
  int iU1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {color1,color1,color1,color1},
                {bande,bande,bande,bande}
            };
            
    //V
  int iV1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {0,color1,color1,0},
                {0,color1,color1,0},
                {bande,bande,bande,bande}
            };
            
    //W
  int iW1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {color1,0,0,color1},
                {color1,color1,color1,color1},
                {color1,0,0,color1},
                {bande,bande,bande,bande}
            };
            
    //X
  int iX1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {0,0,0,0},
                {color1,0,0,color1},
                {0,color1,color1,0},
                {0,color1,color1,0},
                {color1,0,0,color1},
                {bande,bande,bande,bande}
            };
            
    //Y
  int iY1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {0,0,0,0},
                {color1,0,0,color1},
                {0,color1,color1,0},
                {0,color1,0,0},
                {color1,0,0,0},
                {bande,bande,bande,bande}
            };
            
    //Z
  int iZ1[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {0,0,0,0},
                {color1,color1,color1,color1},
                {0,0,color1,0},
                {0,color1,0,0},
                {color1,color1,color1,color1},
                {bande,bande,bande,bande}
            };
            
            
            
   ///////////////////////////SECOND LETTERS
   //A
  int iA2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {color2,0,0,color2},
                {color2,color2,color2,color2},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {bande,bande,bande,bande}
            };
        
  //B
  int iB2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,0,0,0},
                {color2,0,0,0},
                {color2,color2,color2,color2},
                {color2,0,0,color2},
                {color2,color2,color2,color2},
                {bande,bande,bande,bande}
            };
            
  //C
  int iC2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {color2,0,0,0},
                {color2,0,0,0},
                {color2,0,0,0},
                {color2,color2,color2,color2},
                {bande,bande,bande,bande}
            };
  
  //D
  int iD2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {0,0,0,color2},
                {0,0,0,color2},
                {color2,color2,color2,color2},
                {color2,0,0,color2},
                {color2,color2,color2,color2},
                {bande,bande,bande,bande}
            };
            
  //E
  int iE2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {color2,0,0,0},
                {color2,color2,color2,color2},
                {color2,0,0,0},
                {color2,color2,color2,color2},
                {bande,bande,bande,bande}
            };
  
  //F
  int iF2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {color2,0,0,0},
                {color2,color2,color2,0},
                {color2,0,0,0},
                {color2,0,0,0},
                {bande,bande,bande,bande}
            };
        
  //G
  int iG2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {color2,0,0,0},
                {color2,0,color2,color2},
                {color2,0,0,color2},
                {color2,color2,color2,color2},
                {bande,bande,bande,bande}
            };
    
  //H
  int iH2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {color2,color2,color2,color2},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {bande,bande,bande,bande}
            };
            
  //I
  int iI2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {0,color2,color2,0},
                {0,color2,color2,0},
                {0,color2,color2,0},
                {color2,color2,color2,color2},
                {bande,bande,bande,bande}
            };
            
  //J
  int iJ2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {0,0,color2,0},
                {0,0,color2,0},
                {0,0,color2,0},
                {color2,color2,color2,0},
                {bande,bande,bande,bande}
            };
            
  //K
  int iK2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,0,0,color2},
                {color2,0,color2,0},
                {color2,color2,0,0},
                {color2,0,color2,0},
                {color2,0,0,color2},
                {bande,bande,bande,bande}
            };
            
  //L
  int iL2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,0,0,0},
                {color2,0,0,0},
                {color2,0,0,0},
                {color2,0,0,0},
                {color2,color2,color2,color2},
                {bande,bande,bande,bande}
            };
            
  //M
  int iM2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,0,0,color2},
                {color2,color2,color2,color2},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {bande,bande,bande,bande}
            };
            
    //N
  int iN2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {0,0,0,0},
                {color2,0,0,color2},
                {color2,color2,0,color2},
                {color2,0,color2,color2},
                {color2,0,0,color2},
                {bande,bande,bande,bande}
            };
            
    //O
  int iO2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {color2,color2,color2,color2},
                {bande,bande,bande,bande}
            };
            
    //P
  int iP2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {color2,0,0,color2},
                {color2,color2,color2,color2},
                {color2,0,0,0},
                {color2,0,0,0},
                {bande,bande,bande,bande}
            };
            
    //Q
  int iQ2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {color2,color2,color2,color2},
                {0,0,0,color2},
                {bande,bande,bande,bande}
            };
            
    //R
  int iR2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {color2,0,0,color2},
                {color2,color2,color2,color2},
                {color2,0,color2,0},
                {color2,0,0,color2},
                {bande,bande,bande,bande}
            };
            
    //s
  int iS2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {color2,0,0,0},
                {color2,color2,color2,color2},
                {0,0,0,color2},
                {color2,color2,color2,color2},
                {bande,bande,bande,bande}
            };
            
    //T
  int iT2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,color2,color2,color2},
                {color2,color2,color2,color2},
                {0,color2,color2,0},
                {0,color2,color2,0},
                {0,color2,color2,0},
                {bande,bande,bande,bande}
            };
            
    //U
  int iU2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {color2,color2,color2,color2},
                {bande,bande,bande,bande}
            };
            
    //V
  int iV2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {0,color2,color2,0},
                {0,color2,color2,0},
                {bande,bande,bande,bande}
            };
            
    //W
  int iW2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {color2,0,0,color2},
                {color2,color2,color2,color2},
                {color2,0,0,color2},
                {bande,bande,bande,bande}
            };
            
    //X
  int iX2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {0,0,0,0},
                {color2,0,0,color2},
                {0,color2,color2,0},
                {0,color2,color2,0},
                {color2,0,0,color2},
                {bande,bande,bande,bande}
            };
            
    //Y
  int iY2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {0,0,0,0},
                {color2,0,0,color2},
                {0,color2,color2,0},
                {0,color2,0,0},
                {color2,0,0,0},
                {bande,bande,bande,bande}
            };
            
    //Z
  int iZ2[8][4]= {
                {bande,bande,bande,bande},
                {bande,bande,bande,bande},
                {0,0,0,0},
                {color2,color2,color2,color2},
                {0,0,color2,0},
                {0,color2,0,0},
                {color2,color2,color2,color2},
                {bande,bande,bande,bande}
            };
        
        
    /////////////////////SWITCH1
    switch(Choix1)
    {
        case 'a':
        EgalTab(iTab1,iA1);
        break;
        
        case 'b':
        EgalTab(iTab1,iB1);
        break;
        
        case 'c':
        EgalTab(iTab1,iC1);
        break;
        
        case 'd':
        EgalTab(iTab1,iD1);
        break;
        
        case 'e':
        EgalTab(iTab1,iE1);
        break;
        
        case 'f':
        EgalTab(iTab1,iF1);
        break;
        
        case 'g':
        EgalTab(iTab1,iG1);
        break;
        
        case 'h':
        EgalTab(iTab1,iH1);
        break;
        
        case 'i':
        EgalTab(iTab1,iI1);
        break;
        
        case 'j':
        EgalTab(iTab1,iJ1);
        break;
        
        case 'k':
        EgalTab(iTab1,iK1);
        break;
        
        case 'l':
        EgalTab(iTab1,iL1);
        break;
        
        case 'm':
        EgalTab(iTab1,iM1);
        break;
        
        case 'n':
        EgalTab(iTab1,iN1);
        break;
        
        case 'o':
        EgalTab(iTab1,iO1);
        break;
        
        case 'p':
        EgalTab(iTab1,iP1);
        break;
        
        case 'q':
        EgalTab(iTab1,iQ1);
        break;
        
        case 'r':
        EgalTab(iTab1,iR1);
        break;
        
        case 's':
        EgalTab(iTab1,iS1);
        break;
        
        case 't':
        EgalTab(iTab1,iT1);
        break;
        
        case 'u':
        EgalTab(iTab1,iU1);
        break;
        
         case 'v':
        EgalTab(iTab1,iV1);
        break;
        
         case 'w':
        EgalTab(iTab1,iW1);
        break;
        
         case 'x':
        EgalTab(iTab1,iX1);
        break;
        
         case 'y':
        EgalTab(iTab1,iY1);
        break;
        
         case 'z':
        EgalTab(iTab1,iZ1);
        break;
        
    }
    
    
    /////////////////////SWITCH2
    switch(Choix2)
    {
         case 'a':
        EgalTab(iTab2,iA2);
        break;
        
        case 'b':
        EgalTab(iTab2,iB2);
        break;
        
        case 'c':
        EgalTab(iTab2,iC2);
        break;
        
        case 'd':
        EgalTab(iTab2,iD2);
        break;
        
        case 'e':
        EgalTab(iTab2,iE2);
        break;
        
        case 'f':
        EgalTab(iTab2,iF2);
        break;
        
        case 'g':
        EgalTab(iTab2,iG2);
        break;
        
        case 'h':
        EgalTab(iTab2,iH2);
        break;
        
        case 'i':
        EgalTab(iTab2,iI2);
        break;
        
        case 'j':
        EgalTab(iTab2,iJ2);
        break;
        
        case 'k':
        EgalTab(iTab2,iK2);
        break;
        
        case 'l':
        EgalTab(iTab2,iL2);
        break;
        
        case 'm':
        EgalTab(iTab2,iM2);
        break;
        
        case 'n':
        EgalTab(iTab2,iN2);
        break;
        
        case 'o':
        EgalTab(iTab2,iO2);
        break;
        
        case 'p':
        EgalTab(iTab2,iP2);
        break;
        
        case 'q':
        EgalTab(iTab2,iQ2);
        break;
        
        case 'r':
        EgalTab(iTab2,iR2);
        break;
        
        case 's':
        EgalTab(iTab2,iS2);
        break;
        
        case 't':
        EgalTab(iTab2,iT2);
        break;
        
        case 'u':
        EgalTab(iTab2,iU2);
        break;
        
         case 'v':
        EgalTab(iTab2,iV2);
        break;
        
         case 'w':
        EgalTab(iTab2,iW2);
        break;
        
         case 'x':
        EgalTab(iTab2,iX2);
        break;
        
         case 'y':
        EgalTab(iTab2,iY2);
        break;
        
         case 'z':
        EgalTab(iTab2,iZ2);
        break;
        
    }
    
    
    
    
    int iTab[8][8];
    for(int i=0;i<8;i++)
    {
        for(int j=0;j<8;j++)
        {
             if(j>3)
             {
                 iTab[i][j]=iTab2[i][j-4];
             }
             else
             {
                 iTab[i][j]=iTab1[i][j];
             }
             
        }
    }


    int k=0,l,n;
    for(l=7; l>-1; l--) {
        if(k%2==1) {
            for(n=7; n>-1; n--) {
                switch(iTab[l][n]) {
                    case 0:
                        colorbuf[(k*8)+7-n]=0x000000;
                        break;
                    case 1:
                        colorbuf[(k*8)+7-n]=0xff0000;
                        break;
                    case 2:
                        colorbuf[(k*8)+7-n]=0x00ff00;
                        break;
                    case 3:
                        colorbuf[(k*8)+7-n]=0x0000ff;
                        break;
                    case 4:
                        colorbuf[(k*8)+7-n]=0xffff00;
                        break;
                    case 5:
                        colorbuf[(k*8)+7-n]=0x582900;
                        break;
                    case 6:
                        colorbuf[(k*8)+7-n]=0xffffff;
                        break;
                    case 7:
                        colorbuf[(k*8)+7-n]=0xfA25CB;
                        break;
                    case 8:
                        colorbuf[(k*8)+7-n]=0x606060;
                        break;
                    case 9:
                        colorbuf[(k*8)+7-n]=0x7f00ff;
                        break;
                }
            }
            k++;
        } else if(k%2==0) {
            for(n=0; n<8; n++) {
                switch(iTab[l][n]) {
                    case 0:
                        colorbuf[(k*8)+n]=0x000000;
                        break;
                    case 1:
                        colorbuf[(k*8)+n]=0xff0000;
                        break;
                    case 2:
                        colorbuf[(k*8)+n]=0x00ff00;
                        break;
                    case 3:
                        colorbuf[(k*8)+n]=0x0000ff;
                        break;
                    case 4:
                        colorbuf[(k*8)+n]=0xffff00;
                        break;
                    case 5:
                        colorbuf[(k*8)+n]=0x582900;
                        break;
                    case 6:
                        colorbuf[(k*8)+n]=0xffffff;
                        break;
                    case 7:
                        colorbuf[(k*8)+n]=0xfA25CB;
                        break;
                    case 8:
                        colorbuf[(k*8)+n]=0x606060;
                        break;
                    case 9:
                        colorbuf[(k*8)+n]=0x7f00ff;
                        break;
                }
            }
            k++;
        }
    }



    for (int d=0+64*NbrAfficheur; d<NUM_COLORS; d++)
    {
        colorbuffer[d]=colorbuf[d-64*NbrAfficheur];
    }
    NbrAfficheur++;
 
 




}
void NewDisplay()
{
    NbrAfficheur=0;
}

void Display()
{
 

// set up the colours we want to draw with
//int colorbuf[NUM_COLORS] = {0x000000,0x000000,0x8B6C42,0x8B6C42,0x000000,0xff0000,0x2f2f00,0xff0000,0xff0000,0x2f2f00,0xff0000,0x00ff00,0x00ff00,0x00ff00,0x00ff00,0x00ff00};

// for each of the colours (j) write out 10 of them
// the pixels are written at the colour*10, plus the colour position
// all modulus 60 so it wraps around
for (int i = 0; i < WS2812_BUF; i++)
{
    px.Set(i, colorbuffer[(i) % NUM_COLORS]);
}

// now all the colours are computed, add a fade effect using intensity scaling
// compute and write the II value for each pixel
for (int j=0; j<WS2812_BUF; j++)
{
    // px.SetI(pixel position, II value)
    px.SetI(j%WS2812_BUF, 0xf+(0xff*(j%1)));
}


// Now the buffer is written, rotate it
// by writing it out with an increasing offset
for (int z=WS2812_BUF; z >= 0 ; z--)
{
    ws.write_offsets(px.getBuf(),z,z,z);
    //wait(0.075);
}

}