/*
 * link.h
 *
 *  Created on: 19 sep. 2013
 *      Author: basilfx
 */

#ifndef __TINYLINK_H__
#define __TINYLINK_H__

#include "mbed.h"

// This can be anything, and is used to synchronize a frame
#define PREAMBLE 0xAA55AA55L

// Message flags
#define FLAG_NONE 0x00
#define FLAG_RESET 0x01

// Don't change these values!
#define LEN_PREAMBLE    (sizeof(PREAMBLE))
#define LEN_FLAGS       2
#define LEN_LENGTH      2
#define LEN_XOR         1
#define LEN_CRC         4
#define LEN_HEADER      (LEN_FLAGS + LEN_LENGTH + LEN_XOR)
#define LEN_BODY        LEN_CRC

// Protocol states
typedef enum {
    WAITING_FOR_PREAMBLE = 1,
    WAITING_FOR_HEADER,
    WAITING_FOR_BODY
} tinylink_state_e;

struct frame_t {
    uint8_t damaged;
    uint16_t length;
    uint16_t flags;
    uint8_t* data;
};

class TinyLink {
public:
    TinyLink(FILE* _handle, uint8_t* _buffer, size_t _length);

    size_t reset();

    size_t write(uint8_t* buffer, size_t length, uint16_t flags);
    size_t write(uint8_t* buffer, size_t length);
    size_t write(frame_t* frame);
    
    int read(size_t limit, frame_t* frame);
    int read(size_t limit, frame_t* frame, uint8_t ignoreDamaged);
protected:
private:
    uint8_t checksumHeader(uint16_t flags, uint16_t length);
    uint32_t checksumFrame(uint8_t* data, size_t length, uint8_t checksumHeader);

    FILE* handle;
    size_t maxLength;
    uint8_t* buffer;
    
    size_t index;
    tinylink_state_e state;
};

#endif
