#include "Crc.h"

static void CRC32Value(uint32_t &CRC, uint8_t c) {
    uint32_t ulTemp1 = ( CRC >> 8 ) & 0x00FFFFFFL;
    uint32_t ulCRC = ((int) CRC ^ c ) & 0xff;
    uint8_t length = 8;

    while (length--) {
        if ( ulCRC & 1 ) {
            ulCRC = ( ulCRC >> 1 ) ^ CRC32_POLYNOMIAL;
        } else {
            ulCRC >>= 1;
        }
    }

    CRC = ulTemp1 ^ ulCRC;
}

namespace crc {
    uint32_t CRC32(uint8_t value) {
        return crc::CRC32(0, &value, 1);
    }

    uint32_t CRC32(uint32_t initial, uint8_t value) {
        return crc::CRC32(initial, &value, 1);
    }

    uint32_t CRC32(uint8_t* buffer, size_t length) {
        return crc::CRC32(0, buffer, length);
    }

    uint32_t CRC32(uint32_t initial, uint8_t* buffer, size_t length) {
        uint32_t result = initial;

        while (length--) {
            CRC32Value(result, *buffer++);
        }

        return result;
    }
}