#include "mbed.h"
#include "SDFileSystem.h"
#include "EthernetInterface.h"
#include "BME280.h"
#include <iostream>
#include <fstream>

#define NUMBER_OF_LINES     23
#define COLOR_LINE          12
#define TEMPERATURE_LINE    17
#define PRESSURE_LINE       18
#define HUMADITY_LINE       19
#define RAINFALL_LINE       20
#define TIME_LINE           21

Serial pc(USBTX, USBRX);
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); 
BME280 sensor(PTC11, PTC10);
DigitalIn sw(PTD1);
TCPSocketServer svr;
TCPSocketConnection client;

string file_content[NUMBER_OF_LINES];
volatile bool rain = false;

void sendData(void);
void initializeEthernet(void);
void readHTMLCode(void);
void getWeatherConditions(void);
void initializeSerialPC(void);
void initializeTCP(void);

int main()
{
    initializeSerialPC();
    readHTMLCode();   
    initializeEthernet();
    initializeTCP();
    while(1)
    {
        if (svr.accept(client))
        {
            pc.printf("Connection with client can not be established.\r");
        }
        else
        {
            pc.printf("Connection with client established, client ip addres: %s.\r", client.get_address());
            wait(1);
            sendData();
            client.close();
        }
        //getWeatherConditions();

    }
}

void sendData(void)
{
    string tmp = "";
    for (int i = 0; i < NUMBER_OF_LINES; i++)
        tmp += file_content[i];
    client.send(const_cast<char*>(tmp.c_str()),tmp.length());
}

void initializeTCP(void)
{
    if (svr.bind(80) < 0)
    {
        pc.printf("Server TCP cannot bound with port 80(HTTP).\r");
        return;
    }
    else
        pc.printf("Server TCP bound with port 80(HTTP).\r"); 
    if (svr.listen(1) < 0)
    {
        pc.printf("Server TCP cannot listen incominng conections.\r"); 
        return;
    }
    else
    {
        pc.printf("Server TCP started listen incominng conections.\r"); 
    }
}

void initializeEthernet(void)
{
    EthernetInterface eth;
    const char *ip = "192.168.1.2";
    const char *mask = "255.255.255.0";
    const char *gateway = "192.168.1.1";
    if(!eth.init(ip,mask,gateway))
    {   
        pc.printf("Ethernet card initialized successfully.\r");
        eth.connect();        
        pc.printf("IP address: %s\n",eth.getIPAddress());
        pc.printf("Network mask: %s\n",eth.getNetworkMask());
        pc.printf("Gateway: %s\n",eth.getGateway());
        pc.printf("MAC address: %s\n",eth.getMACAddress());
    }
    else
        pc.printf("Ethernet card could not be initialized.\r");    
    return; 
}

void readHTMLCode(void)
{
    fstream file;    
    int cnt = 0;
    for (int i = 0; i < NUMBER_OF_LINES; i++)
        file_content[i] = " ";
    file.open("/sd/index.html", ios::in);
    if (file.good())
    {
        pc.printf("The index.html file has been opened. \r");
        while(!file.eof())
        {
            getline(file,file_content[cnt]);
            cnt++;           
        }
        file.close();
        pc.printf("The file has been closed. \r");
    }
    else
    {
        pc.printf("The file could not be opened. \r");
        return;
    }
}

void getWeatherConditions(void)
{
    float temperature;
    float humidity;
    float pressure;
    pressure = sensor.getPressure();
    temperature = sensor.getTemperature();
    humidity = sensor.getHumidity();
    pc.printf("%2.2f degC, %04.2f hPa, %2.2f %%\r", temperature, pressure, humidity);
    
    if (sw == 1) 
    {
        pc.printf("Rain!\r");
        rain = true;
    }
    else
    {
        pc.printf("No rain!\r");
        rain = false;
    }
}

void initializeSerialPC(void)
{
    pc.baud(115200);
    pc.printf("Serial port initialized. \r");
}

