/*******************************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/
#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "MAX30205.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

// Virtual serial port over USB
//USBSerial microUSB; 
Serial uart2(P3_1, P3_0,9600);

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);

//Get I2C instance
I2C i2cBus(I2C1_SDA, I2C1_SCL);
 
//Get temp sensor instance
MAX30205 bodyTempSensor(i2cBus, (0x90 >> 1));

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)

/**
* @brief Sample main program for MAX30205
* @version 1.0000.0
*
* @details Sample main program for MAX30205.
* The prints are sent to the terminal window (9600, 8n1).
* The program initially flashes yellow once, then it
* blinks green if it's able to communicate with
* the MAX30205, otherwise, it blinks red.
* The temperature is read out every half second.
* To run the program, drag and drop the .bin file into the 
* DAPLINK folder. After it finishes flashing, cycle the power or 
* reset the Pegasus after flashing by pressing the button on
* the Pegasus next to the battery connector or the button
* on the MAXREFDES100HDK.
*/

int main()
{
    int32_t ret;
    uint16_t hystValue = 0;
    uint16_t temperatureValue;
    uint32_t expandTemperatureValue=0;
    float Celsius;

    gLED = LED_ON;
    rLED = LED_ON;  // init LED to yellow
    bLED = LED_OFF;
    wait(0.05);
    
    uart2.printf("Example program for MAX20305.\r\n");
    ret = bodyTempSensor.readTHYST(hystValue);
    if (ret != 0) {
        uart2.printf("Communications to MAX20305 Failed: ret=%d, Thyst=0x%04X\r\n",ret, hystValue);
        rLED = LED_ON;
    }
 
    while(true) {
        ret=bodyTempSensor.readTemperature(temperatureValue);
        if(!ret)
        {
            expandTemperatureValue = (uint32_t)temperatureValue;
            Celsius = bodyTempSensor.toCelsius(expandTemperatureValue);
            uart2.printf("The temperature is %f Celsius, ",Celsius);
            uart2.printf("%f Fahrenheit\r\n",bodyTempSensor.toFahrenheit(Celsius));

            rLED = LED_OFF;
            gLED = !gLED;  // blink the green red
            bLED = LED_OFF;
        } else {
            rLED = !rLED;  // blink the LED red
            gLED = LED_OFF;
            bLED = LED_OFF;
        }
        wait(0.5);
    
    }

}

