#include "mbed.h"

/*****************************************************************************
generar un programa que controle por el puerto serial el grado de 4 servo motores
por medio de la comunicacion serial donde el comando sea 

|            |            |             |
|   INITCMD  |   N_motor  |   N_grados  |
|     0xff   | 0x01- 0x04 | 0x00 - 0xb4 |

para enviar los comandos usar el programa Coolterm
*****************************************************************************/


Serial command(USBTX, USBRX);
PwmOut myservo1(PB_4);
PwmOut myservo2(PB_5);
PwmOut myservo3(PB_10);
PwmOut myservo4(PB_3);
PwmOut myservo5(PB_6);

/*INGRESE L A CONFIGURACION DE LOS MOTORES*/

#define INITCMD 0xFF
#define DEGREES_MAX 180
// definición de las variables globales 

uint8_t N_motor;    // almacena el número de motor
uint8_t N_grados;    // almacena los grados que se mueve el motor
uint8_t N_tm;        //tipo de motor

// definición de las funciones
void setup_uart();
void setup_servo();

void mover_servo(uint8_t motor, uint8_t grados);

void leer_datos();

    
    
int main() {

    setup_uart();
    setup_servo();
   // command.printf("inicio de programa");
    while(1){    
        leer_datos();
        mover_servo(N_motor, N_grados);
    }    
}



void setup_uart(){
    command.baud(115200);
}

void setup_servo(){
    myservo1.period_ms(20);
    myservo1.pulsewidth_us(1000);
    myservo2.period_ms(20);
    myservo2.pulsewidth_us(1000);
    myservo3.period_ms(20);
    myservo3.pulsewidth_us(1000);
    myservo4.period_ms(20);
    myservo4.pulsewidth_us(1000);
    myservo5.period_ms(20);
    myservo5.pulsewidth_us(1000);
}

void leer_datos(){
    while(command.getc()!= INITCMD);
    N_motor=command.getc();
    N_grados=command.getc();
    
}

uint32_t degrees2usec(uint8_t grados,uint8_t tm){
// Retorno el valor en usegundos, donde
//     y − y1 = m(x − x1 )
    if(grados <= DEGREES_MAX)
        if (tm==0)return int(700+grados*1700/180);// u6
        else return int(700+grados*1700/180);// u6
    return 700;
    
}


void mover_servo(uint8_t motor, uint8_t grados){

        uint32_t dpulse=0;
        
/* complementar el código necesario
   tip: deben pasar  grados a microsegundo */

    dpulse=degrees2usec(grados);
    if (motor==1)
        myservo1.pulsewidth_us(dpulse);
    if (motor==2)
        myservo2.pulsewidth_us(dpulse);
    if (motor==3)
        myservo3.pulsewidth_us(dpulse);
    if (motor==4)
        myservo4.pulsewidth_us(dpulse);
    if (motor==5)
        myservo5.pulsewidth_us(dpulse);
}


