#ifndef INCL_ROBOTLIBRARY_H
#define INCL_ROBOTLIBRARY_H

#include "mbed.h"
#include "USBSerial.h"

#define bluetoothAvailable() (bt.readable())
#define sendBluetoothChar(toSend) (bt.putc((char)toSend))
#define getBluetoothChar() ((char) bt.getc())
#include "string_functions.h"
//#define robotPrint(toPrint) console1.printf(toPrint)
//#define robotPrintln(toPrint) console1.printf(toPrint)

#define PRINT_DEBUG 0
#if PRINT_DEBUG == 1
//#define robotPrintDebug(toPrint) robotPrint(toPrint)
//#define robotPrintlnDebug(toPrint) robotPrintln(toPrint)
#else
//#define robotPrintDebug(toPrint)
//#define robotPrintlnDebug(toPrint)
#endif

extern Serial bt; // tx, rx
//extern USBSerial console1;
extern char bluetoothData[50];
bool getBluetoothData();
bool isBluetoothConnected();
void setBluetoothConnected(bool btCon);
void processBluetoothData();
char* returnBluetoothData();
bool isBluetoothDataValid();
void robotLoop();
void robotSetup(int baud_rate);
void sendBluetoothData(const char* data);

#endif