#include "mbed.h"
#include "EthernetNetIf.h"
#include "Ranger.h"
#include "XPlaneIO.h"

Serial pc(USBTX, USBRX);

int main() {

    pc.baud(57600);
    
    Ethernet ethernet;

    XPlaneIO xpio;
    if (! xpio.setup("XPlaneIO.cfg", &ethernet)) {
        printf("Config/setup failed \n");
        return -1;
    }
    
    // Check if user wants to perform interactive XPlaneIO diagnostics.
    xpio.diagnostics(pc);
    
    AnalogOut throttleActual(p18);
    xpio.addDATAToReceive(26);  // "throttle actual" in msg 26, data[0]

    AnalogIn hatSwitch(p16);
    XPlaneUdpDREF pilotHeadHeading("sim/graphics/view/pilots_head_psi", xpio.reverseByteOrder());
    Ranger<float> hatSwitchInputRanger(4,  0.59, 0.68, 0.78, 0.92);
    float hatSwitchDegreesByRange[5] = {0, -90, 180, 90, 0};

    Timer timerThrottle;
    timerThrottle.start();

    Timer timerHatSwitch;
    timerHatSwitch.start();

    Timer timerDebugPrint;
    if (xpio.debug()) {
        timerDebugPrint.start();
    }

    xpio.startSendingUdp();

    while (1) {
        Net::poll();
        
        if (timerThrottle.read_ms() > 500) {
            timerThrottle.reset();
            
            throttleActual.write(xpio.getReceiveDATAValue(26, 0));     // throttle actual
        }

        if (timerHatSwitch.read_ms() > 250) {
            timerHatSwitch.reset();
            
            int newRange = hatSwitchInputRanger.range(hatSwitch.read());
            if (hatSwitchInputRanger.rangeChanged()) {
                pilotHeadHeading.drefFloat(hatSwitchDegreesByRange[newRange]);
                xpio.sendDREF(pilotHeadHeading);
            }
        }

        if (xpio.debug()) {
            if (timerDebugPrint.read() > 2) {
                timerDebugPrint.reset();
                
                printf("Receive ");
                printXPlaneUdpDATAMap(stdout, xpio.recvDATAMap());
                printf("Send ");
                printXPlaneUdpDATAMap(stdout, xpio.sendDATAMap());
            }
        }
    }
}
