#ifndef XPLANEUDPENCODER_H_INCLUDED
#define XPLANEUDPENCODER_H_INCLUDED

#include "XPlaneUdp.h"
#include "XPlaneUdpDATA.h"
#include "XPlaneUdpDATAMap.h"
#include "XPlaneUdpDREF.h"

#define DATAREF_PACKET_SIZE 509    // "DREF" + '\x00' + 4-byte_value + 500-char_name

class XPlaneUdpEncoder {
public:

    //XPlaneUdpEncoder();
    
    void setDebug(bool debug);

    /**
     * Encode a DATA packet from the messages in the given XPlaneUdpDATAMap.
     * The encoded data will be placed at the location given by udpBuffer.
     * If changedDataOnly is true, then only XPlaneUdpDATA messages with dataChanged will be encoded.
     * Return number of bytes encoded into udpBuffer.
     * Return -1 if there's more data in the map than what will fit in udpBuffer (> maxBufferLen).
     */
    int encodeFromDATAMap(char * udpBuffer, int maxBufferLen, XPlaneUdpDATAMap & DATAMap, bool changedDataOnly);

    /**
     * Encode a DataRef (DREF) packet, using the given DataRef.
     * The encoded data will be placed at the location given by udpBuffer.
     * Return number of bytes encoded into udpBuffer.
     * Return -1 if there's more data in the map than what will fit in udpBuffer (> maxBufferLen).
     */
    int encodeDataRef(char * udpBuffer, int maxBufferLen, XPlaneUdpDREF & dref);

private:

    bool _debug;
};


#endif // XPLANEUDPENCODER_H_INCLUDED
