#include <stdio.h>
#include <string.h>
#include "XPlaneUdp.h"
#include "XPlaneUdpDecoder.h"
#include "XPlaneUdpDATA.h"

void XPlaneUdpDecoder::setDebug(bool debug) {
    _debug = debug;
}

void XPlaneUdpDecoder::setReverseByteOrder(bool reverseByteOrder) {
    _reverseByteOrder = reverseByteOrder;
}

XPlaneUdpMessageType XPlaneUdpDecoder::setUdpBuffer(char * buf, int bufLen) {
    _udpPacketMsgType = UNKNOWN;
    _udpBuffer = buf;
    _udpBufferLen = bufLen;
    //_udpBuffer[bufLen] = 0; // only need to do this if treating buffer like a string, e.g. printing it

    if (_udpBufferLen >= 5) {
        if (strncmp(_udpBuffer, "DATA", 4) == 0) {
            if (_debug) printf("Got DATA pkt \n");
            _udpPacketMsgType = DATA;
        }
    }
    
    return _udpPacketMsgType;
}

int XPlaneUdpDecoder::putIntoDATAMap(XPlaneUdpDATAMap & DATAMap, bool filter) {
    int updateCount = 0;
    
    if (_udpPacketMsgType != DATA) {
        return 0;
    }
    
    if (filter && (DATAMap.size() == 0)) {
        return 0;
    }
    
    int dataMsgCount = (_udpBufferLen - 5) / XPLANE_DATA_MSG_LENGTH;
    if (_debug) printf("%d msgs in pkt \n", dataMsgCount);
    int bufOffset = 5;
    for (int msgNbr = 0; msgNbr < dataMsgCount; msgNbr++) {
    
        int index;
        memcpy(&index, _udpBuffer + bufOffset, 4);
        if (_reverseByteOrder) {
            reverse4Bytes((char*) &index);
        }
        
        XPlaneUdpDATA *DATAmsg = getXPlaneUdpDATA(DATAMap, index);
        if (DATAmsg != NULL) {
            DATAmsg->setAllData(_udpBuffer + bufOffset);
            updateCount++;
        }
        else if (! filter) {
            DATAmsg = new XPlaneUdpDATA(index, _reverseByteOrder);
            DATAmsg->setAllData(_udpBuffer + bufOffset);
            DATAMap[index] = DATAmsg;
            updateCount++;
        }
        
        bufOffset += XPLANE_DATA_MSG_LENGTH;
    }
    
    return updateCount;
}
