#ifndef XPLANEUDPDATAMAP_H_INCLUDED
#define XPLANEUDPDATAMAP_H_INCLUDED

#include <map>
#include "XPlaneUdpDATA.h"

/**
 * Map of XPlaneUdpDATA pointers, keyed by int (e.g. keyed by the DATA message index).
 */
typedef std::map<int, XPlaneUdpDATA *> XPlaneUdpDATAMap;

/**
 * Function to return the XPlaneUdpDATA pointer in the given map, keyed by the given int index.
 * If no map entry exists for the given key index, then returns NULL.
 */
XPlaneUdpDATA * getXPlaneUdpDATA(const XPlaneUdpDATAMap & DATAMap, int index);

/**
 * Function to include a DATA message, of the given index, in the given map.
 * If a message of the given index already exists in the map, then do nothing.
 * Returns true if a new DATA message was created and added to the map.
 */
bool addXPlaneUdpDATAToMap(XPlaneUdpDATAMap & DATAMap, int index, bool reverseByteOrder);

/**
 * Function to reset the dataChanged flag in all DATA messages in the given map.
 */
void resetDataChangedInMap(XPlaneUdpDATAMap & DATAMap);

/**
 * Utility function to print the DATA messages in the given map.
 */
void printXPlaneUdpDATAMap(FILE * outputStream, XPlaneUdpDATAMap & DATAMap);

#endif // XPLANEUDPDATAMAP_H_INCLUDED
