#include "XPlaneUdpDATAMap.h"

XPlaneUdpDATA * getXPlaneUdpDATA(const XPlaneUdpDATAMap & DATAMap, int index) {
    XPlaneUdpDATAMap::iterator iter = DATAMap.find(index);
    if (iter != DATAMap.end()) {
        return iter->second;
    }
    else {
        return NULL;
    }
}

bool addXPlaneUdpDATAToMap(XPlaneUdpDATAMap & DATAMap, int index, bool reverseByteOrder) {
    XPlaneUdpDATA *DATAmsg = getXPlaneUdpDATA(DATAMap, index);
    if (DATAmsg != NULL) {
        return false;
    }
    else {
        DATAmsg = new XPlaneUdpDATA(index, reverseByteOrder);
        DATAMap[index] = DATAmsg;
        return true;
    }
}

void resetDataChangedInMap(XPlaneUdpDATAMap & DATAMap) {
    for (XPlaneUdpDATAMap::iterator it = DATAMap.begin(); it != DATAMap.end(); it++) {
        (it->second)->resetDataChanged();
    }
}

void printXPlaneUdpDATAMap(FILE * outputStream, XPlaneUdpDATAMap & DATAMap) {
    fprintf(outputStream, "Map:\n");
    for (XPlaneUdpDATAMap::iterator it = DATAMap.begin(); it != DATAMap.end(); it++) {
        //(it->second)->resetDataChanged();
        fprintf(outputStream, "    key: %d  value: ", it->first);
        (it->second)->toString(outputStream);
        fprintf(outputStream, "\n");
    }
}
