#include "Scaler.h"
#include "XPlaneAnalogIn.h"

XPlaneAnalogIn::XPlaneAnalogIn(PinName pin, Scaler<float> scale1, Scaler<float> scale2, int msgIdx, int msgFloatIdx) : 
    _pin(pin), _scale1(scale1), _scale2(scale2), _xplaneDATAMsgIdx(msgIdx), _xplaneDATAMsgFloatIdx(msgFloatIdx),
    _ain(pin)
{
    _lastUnscaledRead = -1.0;
    _lastScaledRead = -999.0;
    _lastScaleRange = -1;
}

float XPlaneAnalogIn::read_unscaled() {
    _lastUnscaledRead = _ain.read();
    return _lastUnscaledRead;
}

float XPlaneAnalogIn::read_scaled(int & range, bool & scaledOutputNoChange) {
    float scaledOutput;
    float rawInput = read_unscaled();
    
    if (rawInput > _scale1.inputTo()  &&  rawInput < _scale2.inputFrom()) {
        range = 0;
        scaledOutput = (_scale1.outputTo() + _scale2.outputFrom()) / 2.0f;
    }
    else if (rawInput <= _scale1.inputTo()) {
        if (rawInput < _scale1.inputFrom()) {
            range = 3;
            scaledOutput = _scale1.outputFrom();
        }
        else {
            range = 1;
            scaledOutput = _scale1.scale(rawInput);
        }
    }
    else {  // rawInput >= _scale2.inputFrom
        if (rawInput > _scale2.inputTo()) {
            range = 4;
            scaledOutput = _scale2.outputTo();
        }
        else {
            range = 2;
            scaledOutput = _scale2.scale(rawInput);
        }
    }
    
    scaledOutputNoChange = ((scaledOutput == _lastScaledRead) || 
                            (range == _lastScaleRange  &&  (range == 0 || range == 3 || range == 4)));

    _lastScaledRead = scaledOutput;                            
    _lastScaleRange = range;
    
    return scaledOutput;
}

/*
void XPlaneAnalogIn::scale1(Scaler<float> scale1) {
    _scale1 = scale1;
}

void XPlaneAnalogIn::scale2(Scaler<float> scale2) {
    _scale2 = scale2;
}

void XPlaneAnalogIn::xplaneDATAMsgIdx(int xplaneDATAMsgIdx) {
    _xplaneDATAMsgIdx = xplaneDATAMsgIdx;
}

void XPlaneAnalogIn::xplaneDATAMsgFloatIdx(int xplaneDATAMsgFloatIdx) {
    _xplaneDATAMsgFloatIdx = xplaneDATAMsgFloatIdx;
}
*/

int XPlaneAnalogIn::xplaneDATAMsgIdx() {
    return _xplaneDATAMsgIdx;
}

int XPlaneAnalogIn::xplaneDATAMsgFloatIdx() {
    return _xplaneDATAMsgFloatIdx;
}

void XPlaneAnalogIn::toString(FILE * outputStream) {
    fprintf(outputStream, "lastRawRead=%f lastScaledRead=%f lastScaleRange=%d",
            _lastUnscaledRead, _lastScaledRead, _lastScaleRange);
}
