#include "TimeoutPrompt.h"

TimeoutPrompt::TimeoutPrompt(Serial & serialInOut, int defaultTimeoutSeconds) : 
    _serialInOut(serialInOut), _defaultTimeoutSeconds(defaultTimeoutSeconds)
{
    _timer.reset();
}
 
char TimeoutPrompt::prompt(int timeoutSeconds, char *promptString, char* validChars) {
    _serialInOut.printf("%s\n", promptString);
    _timer.reset();
    _timer.start();
    while (_timer.read() < timeoutSeconds) {
        if (_serialInOut.readable()) {
            char c = _serialInOut.getc();
            if (strchr(validChars, c) != NULL) {
                _timer.stop();
                return c;
            }
        }
    }
    _timer.stop();
    return NULL;
}

char TimeoutPrompt::prompt(char *promptString, char* validChars) {
    return prompt(_defaultTimeoutSeconds, promptString, validChars);
}