#include <ctype.h>
#include "LocalConfigFile.h"

LocalConfigFile::LocalConfigFile(char *filename) {
    LocalFileSystem localFileSys("local");  // create the local filesystem under the name "local"
    sprintf(_buf, "/local/%s", filename);   // set full file path into _buf
    printf("Reading config file: %s ... ", _buf);
    if (read(_buf)) {
        printf("Success \n");
    }
    else {
        printf("Problem \n");
    }
}

char LocalConfigFile::getChar(char *key, char defaultVal) {
    if (getValueIntoBuf(key)) {
        if (strlen(_buf) > 0) {
            return _buf[0];
        }
        else {
            printf("getChar(key='%s'): Problem \n", key);
        }
    }
    return defaultVal;
}

bool LocalConfigFile::getBool(char *key, bool defaultVal) {
    char c = getChar(key, '.');
    if (c != '.') {
        c = toupper(c);
        return (c == 'T' || c == 'Y' || c == '1');
    }
    else {
        printf("getBool(key='%s'): Problem \n", key);
    }
    return defaultVal;
}

int LocalConfigFile::getInt(char *key, int defaultVal) {
    if (getValueIntoBuf(key)) {
        int val;
        int cnt = sscanf(_buf, "%d", &val);
        if (cnt == 1) {
            return val;
        }
        else {
            printf("getInt(key='%s'): Problem \n", key);
        }
    }
    return defaultVal;
}

PinName LocalConfigFile::getPin(char *key, PinName defaultVal) {
    const PinName pinName[] = {p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18,
                               p19, p20, p21, p22, p23, p24, p25, p26, p27, p28, p29, p30};
    int p = getInt(key, -1);
    if (p == -1) {
        printf("getPin(key='%s'): Problem \n", key);
    }
    else if (p < 5 || p > 30) {
        printf("getPin(key='%s'): Invalid pin#: %d. Pin# must be between 5 and 30, inclusive.\n", key, p);
    }
    else {
        return pinName[p - 5];
    }
    return defaultVal;
}

bool LocalConfigFile::fillIntArray4(char *key, int *intArray) {
    if (getValueIntoBuf(key)) {
        int a0, a1, a2, a3;
        int cnt = sscanf(_buf, "%d %d %d %d", &a0, &a1, &a2, &a3);
        if (cnt == 4) {
            intArray[0] = a0;
            intArray[1] = a1;
            intArray[2] = a2;
            intArray[3] = a3;
            return true;
        }
        else {
            printf("fillIntArray4(key='%s'): Problem \n", key);
        }
    }
    return false;
}

bool LocalConfigFile::fillFloatArray4(char *key, float *floatArray) {
    if (getValueIntoBuf(key)) {
        float a0, a1, a2, a3;
        int cnt = sscanf(_buf, "%f %f %f %f", &a0, &a1, &a2, &a3);
        if (cnt == 4) {
            floatArray[0] = a0;
            floatArray[1] = a1;
            floatArray[2] = a2;
            floatArray[3] = a3;
            return true;
        }
        else {
            printf("fillFloatArray4(key='%s'): Problem \n", key);
        }
    }
    return false;
}

bool LocalConfigFile::getValueIntoBuf(char *key) {
    if (getValue(key, _buf, sizeof(_buf))) {
        return true;
    }
    else {
        printf("LocalConfigFile.getValueIntoBuf(key='%s'): Problem, or config key not found \n", key);
        return false;
    }
}
