#ifndef XPLANEUDPDECODER_H_INCLUDED
#define XPLANEUDPDECODER_H_INCLUDED

#include "XPlaneUdp.h"
#include "XPlaneUdpDATA.h"
#include "XPlaneUdpDATAMap.h"

class XPlaneUdpDecoder {
public:

    //XPlaneUdpDecoder();
    
    void setDebug(bool debug);
    void setReverseByteOrder(bool reverseByteOrder);

    /**
     * This must be called prior to other methods such as putIntoDATAMap().
     * Point this decoder to the UDP data buffer, and read the first four bytes
     * to determine the X-Plane UDP message type (e.g. DATA).
     */
    XPlaneUdpMessageType setUdpBuffer(char * buf, int bufLen);
    
    /**
     * Note: The setUdpBuffer() method must be called prior to calling this method.
     * Decode the UDP packet. If it is a DATA packet from X-Plane, then populate
     * XPlaneUdpDATA structure(s) in the map.
     * If filter==true, then only existing structures in the map (keyed by message DATA msg index)
     * will be populated, i.e. no new structures will be created in the map.
     * Return the number of XPlaneUdpDATA structures populated/updated in the map.
     */
    int putIntoDATAMap(XPlaneUdpDATAMap & DATAMap, bool filter);

private:

    bool _debug;
    bool _reverseByteOrder;
    char *_udpBuffer;
    int _udpBufferLen;
    XPlaneUdpMessageType _udpPacketMsgType;
};


#endif // XPLANEUDPDECODER_H_INCLUDED
