#ifndef XPLANEUDPDREF_H_INCLUDED
#define XPLANEUDPDREF_H_INCLUDED

#include <map>
#include "mbed.h"
#include "XPlaneUdp.h"

#define DREF_VALUE_NA -999

/**
 * X-Plane DataRef
 */
class XPlaneUdpDREF {
public:

    XPlaneUdpDREF(char * drefName, bool reverseByteOrder);

    /**
     * Accessor for the DataRef name.
     */
    char * drefName() const;
    
    /**
     * Accessor for the DataRef float data value.
     * Returns -999 if not applicable (this DataRef uses an int value).
     */
    float drefFloat() const;
    
    /**
     * Accessor for the DataRef int data value.
     * Returns -999 if not applicable (this DataRef uses a float value).
     */
    int drefInt() const;
    
    /**
     * Mutator for the DataRef float data value.
     * The DataRef int data will be set to -999.
     * The dataChanged flag will also be set.
     */
    void drefFloat(float floatVal);
    
    /**
     * Mutator for the DataRef int data value.
     * The DataRef float data will be set to -999.
     * The dataChanged flag will also be set.
     */
    void drefInt(int intVal);
    
    /**
     * Starting at the given pointer location, populate bytes from the DataRef value and name.
     * Byte order will be reversed, according to the reverseByteOrder property.
     */
    void populateDREFMessage(char * bytes);

    // Methods to read/write flag to track if data has been modified.
    bool isDataChanged() const;
    void setDataChanged();
    void resetDataChanged();

    /**
     * Print a representation of this instance to outputStream.
     */
    void toString(FILE * outputStream);

private:

    char * _drefName;
    float _drefFloat;
    int _drefInt;
    bool _reverseByteOrder;
    bool _dataChanged;
};


#endif // XPLANEUDPDREF_H_INCLUDED
