#include "XPlaneUdpDREF.h"


XPlaneUdpDREF::XPlaneUdpDREF(char * drefName, bool reverseByteOrder) {
    
    _drefName = drefName;
    _reverseByteOrder = reverseByteOrder;
    
    _dataChanged = false;
    _drefFloat = DREF_VALUE_NA;
    _drefInt = DREF_VALUE_NA;
}


char * XPlaneUdpDREF::drefName() const {
    return _drefName;
}

float XPlaneUdpDREF::drefFloat() const {
    return _drefFloat;
}
    
int XPlaneUdpDREF::drefInt() const {
    return _drefInt;
}

void XPlaneUdpDREF::drefFloat(float floatVal) {
    _drefFloat = floatVal;
    _drefInt = DREF_VALUE_NA;
    setDataChanged();
}
    
void XPlaneUdpDREF::drefInt(int intVal) {
    _drefInt = intVal;
    _drefFloat = DREF_VALUE_NA;
    setDataChanged();
}

    /**
     * Starting at the given pointer location, populate bytes from the dataRef value and name.
     * Byte order will be reversed, according to the reverseBytes property.
     */

void XPlaneUdpDREF::populateDREFMessage(char * bytes) {

    if (_drefInt != DREF_VALUE_NA) {
        memcpy(bytes, &_drefInt, 4);
    }
    else {
        memcpy(bytes, &_drefFloat, 4);
    }
    
    if (_reverseByteOrder) {
        reverse4Bytes((char*) bytes);
    }
    
    strcpy(bytes + 4, _drefName);
}

bool XPlaneUdpDREF::isDataChanged() const {
    return _dataChanged;
}

void XPlaneUdpDREF::setDataChanged() {
    _dataChanged = true;
}

void XPlaneUdpDREF::resetDataChanged() {
    _dataChanged = false;
}

void XPlaneUdpDREF::toString(FILE * outputStream) {
    fprintf(outputStream, "DataRef: name=%s, intVal=%d, floatVal=%f, revBytes=%d",
            _drefName, _drefInt, _drefFloat, _reverseByteOrder);
}
