#ifndef XPLANEUDPDATA_H_INCLUDED
#define XPLANEUDPDATA_H_INCLUDED

#include <map>
#include "mbed.h"
#include "XPlaneUdp.h"

#define XPLANE_DATA_MSG_LENGTH 36   // 1 int + 8 floats

class XPlaneUdpDATA {
public:

    XPlaneUdpDATA(int messageIndex, bool reverseByteOrder);

    /**
     * Accessor for the message index of this DATA message.
     */
    int messageIndex() const;
    
    /**
     * Accessor for the float data at the given float index (0-7).
     */
    float getData(int i) const;
    
    /**
     * Mutator for the float data at the given float index (0-7).
     * The dataChanged flag will also be set.
     */
    void setData(int i, float f);
    
    /**
     * Overload the [] operator to return a reference to the float data at the given float index (0-7).
     * NOTE: The dataChanged flag will not be set if this is used to modify the float data.
     */
    float& operator [] (int i);

    /**
     * Fill data[8] with 32 bytes starting at (DATAMessage + 4).
     * Byte order will be reversed, according to the reverseByteOrder property.
     */
    void setAllData(char * DATAMessage);

    /**
     * Starting at the given pointer location, populate 36 bytes from values in index and data[8].
     * Byte order will be reversed, according to the reverseByteOrder property.
     */
    void populateDATAMessage(char * bytes);

    // Methods to read/write flag to track if data has been modified.
    bool isDataChanged() const;
    void setDataChanged();
    void resetDataChanged();

    /**
     * Print a representation of this instance to outputStream.
     */
    void toString(FILE * outputStream);

private:

    int _messageIndex;
    float _data[8];
    bool _reverseByteOrder;
    bool _dataChanged;
};


#endif // XPLANEUDPDATA_H_INCLUDED
