#include "XPlaneUdpDATA.h"


XPlaneUdpDATA::XPlaneUdpDATA(int messageIndex, bool reverseByteOrder) {
    
    _messageIndex = messageIndex;
    _reverseByteOrder = reverseByteOrder;
    for (int i = 0; i < 8; i++) {
        _data[i] = -999.0f;
    }
    
    _dataChanged = false;
}

int XPlaneUdpDATA::messageIndex() const {
    return _messageIndex;
}

float XPlaneUdpDATA::getData(int i) const {
    return _data[i];
}
    
void XPlaneUdpDATA::setData(int i, float f) {
    _data[i] = f;
    setDataChanged();
}

float& XPlaneUdpDATA::operator [] (int i) {
    return _data[i];
}

void XPlaneUdpDATA::setAllData(char * DATAMessage) {
    memcpy(_data, DATAMessage + 4, 32);
    if (_reverseByteOrder) {
        for (int d = 0; d < 8; d++) {
            reverse4Bytes((char*) &(_data[d]));
        }
    }
}

void XPlaneUdpDATA::populateDATAMessage(char * bytes) {
    memcpy(bytes, &_messageIndex, 4);
    if (_reverseByteOrder) {
        reverse4Bytes((char*) bytes);
    }
    memcpy(bytes + 4, _data, 32);
    if (_reverseByteOrder) {
        for (int d = 1; d < 9; d++) {
            reverse4Bytes((char*) bytes + (d * 4));
        }
    }
}

bool XPlaneUdpDATA::isDataChanged() const {
    return _dataChanged;
}

void XPlaneUdpDATA::setDataChanged() {
    _dataChanged = true;
}

void XPlaneUdpDATA::resetDataChanged() {
    _dataChanged = false;
}

void XPlaneUdpDATA::toString(FILE * outputStream) {
    fprintf(outputStream, "idx=%d, 0:%f 1:%f 2:%f 3:%f 4:%f 5:%f 6:%f 7:%f, revBytes=%d",
            _messageIndex,
            _data[0], _data[1], _data[2], _data[3], _data[4], _data[5], _data[6], _data[7],
            _reverseByteOrder);
}
