#include <stdio.h>
#include <string.h>
#include "XPlaneUdp.h"
#include "XPlaneUdpEncoder.h"
#include "XPlaneUdpDATA.h"

void XPlaneUdpEncoder::setDebug(bool debug) {
    _debug = debug;
}

int XPlaneUdpEncoder::encodeFromDATAMap(char * udpBuffer, int maxBufferLen, XPlaneUdpDATAMap & DATAMap, bool changedDataOnly) {
    if (maxBufferLen < 5  ||  DATAMap.size() == 0) {
        return 0;
    }

    strcpy(udpBuffer, "DATA");
    int bufOffset = 5;

    for (XPlaneUdpDATAMap::iterator it = DATAMap.begin(); it != DATAMap.end(); it++) {
        if ((bufOffset + XPLANE_DATA_MSG_LENGTH) > maxBufferLen) {
            break;
        }
        else {
            XPlaneUdpDATA * DATAmsg = it->second;
            if ((!changedDataOnly) || DATAmsg->isDataChanged()) {
                DATAmsg->populateDATAMessage(udpBuffer + bufOffset);
                bufOffset += XPLANE_DATA_MSG_LENGTH;
            }
        }
    }

    if (_debug) printf("encodeFromDATAMap(): Encoded %d bytes into UDP buffer \n", bufOffset);

    return bufOffset;
}


int XPlaneUdpEncoder::encodeDataRef(char * udpBuffer, int maxBufferLen, XPlaneUdpDREF & dref) {
    if (maxBufferLen < DATAREF_PACKET_SIZE) {
        return 0;
    }

    memset(udpBuffer, '\0' , DATAREF_PACKET_SIZE);      // zero out the buffer
    
    strcpy(udpBuffer, "DREF");
    int bufOffset = 5;

    dref.populateDREFMessage(udpBuffer + bufOffset);

    if (_debug) {
        printf("encodeDataRef(): Encoded DREF packet into UDP buffer: ");
        dref.toString(stdout);
        printf("\n");
    }

    return DATAREF_PACKET_SIZE;
}
